/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.assembly;

import edu.unc.bioinf.ubu.assembly.Edge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.samtools.SAMRecord;

public class Node {
    private String sequence;
    private int count = 1;
    private Map<Node, Edge> toEdges = new HashMap<Node, Edge>();
    private Map<Node, Edge> fromEdges = new HashMap<Node, Edge>();
    private Set<SAMRecord> startingReads = new HashSet<SAMRecord>();
    private String source;

    public Node(String sequence, String source) {
        this.sequence = sequence;
        this.source = source;
    }

    public String toString() {
        return this.count + "_" + this.sequence;
    }

    public int hashCode() {
        return this.sequence.hashCode();
    }

    public boolean equals(Object object) {
        Node that = (Node)object;
        return this.sequence.equals(that.sequence);
    }

    public void incrementCount() {
        ++this.count;
    }

    public int getCount() {
        return this.count;
    }

    public Collection<Edge> getToEdges() {
        return this.toEdges.values();
    }

    public Collection<Edge> getFromEdges() {
        return this.fromEdges.values();
    }

    public String getSequence() {
        return this.sequence;
    }

    public void addStartingRead(SAMRecord read) {
        this.startingReads.add(read);
    }

    public String getSource() {
        return this.source;
    }

    private void printMultiEdges() {
        int aboveThreshold = 0;
        for (Edge edge : this.toEdges.values()) {
            if (edge.getCount() <= 50) continue;
            ++aboveThreshold;
        }
        if (aboveThreshold > 1) {
            System.out.println("------- Edge --------");
            for (Edge edge : this.toEdges.values()) {
                System.out.print(edge.getCount() + ", ");
            }
            System.out.println();
        }
    }

    public List<Edge> getInfrequentEdges(double minFreq) {
        ArrayList<Edge> infrequentEdges = new ArrayList<Edge>();
        infrequentEdges.addAll(this.getInfrequentEdges(minFreq, this.toEdges.values()));
        infrequentEdges.addAll(this.getInfrequentEdges(minFreq, this.fromEdges.values()));
        return infrequentEdges;
    }

    private List<Edge> getInfrequentEdges(double minFreq, Collection<Edge> edges) {
        ArrayList<Edge> infrequentEdges = new ArrayList<Edge>();
        double total = this.getEdgeTotal(edges);
        for (Edge edge : edges) {
            if (!((double)edge.getCount() / total < minFreq)) continue;
            infrequentEdges.add(edge);
        }
        return infrequentEdges;
    }

    private double getEdgeTotal(Collection<Edge> edges) {
        double total = 0.0;
        for (Edge edge : edges) {
            total += (double)edge.getCount();
        }
        return total;
    }

    public List<Edge> getFrequentToEdges(double minFreq) {
        ArrayList<Edge> frequentEdges = new ArrayList<Edge>();
        double total = this.getEdgeTotal(this.toEdges.values());
        for (Edge edge : this.toEdges.values()) {
            if (!((double)edge.getCount() / total >= minFreq)) continue;
            frequentEdges.add(edge);
        }
        return frequentEdges;
    }

    public Edge getMostCommonEdge() {
        this.printMultiEdges();
        Edge topEdge = null;
        int freq = 0;
        for (Edge edge : this.toEdges.values()) {
            if (edge.getCount() <= freq) continue;
            topEdge = edge;
            freq = edge.getCount();
        }
        return topEdge;
    }

    public void addToEdge(Node to) {
        Edge edge = this.toEdges.get(to);
        if (edge == null) {
            edge = new Edge(this, to);
            this.toEdges.put(to, edge);
            to.updateFromEdges(edge);
        } else {
            edge.incrementCount();
        }
    }

    public boolean isRootNode() {
        return this.fromEdges.isEmpty();
    }

    private void updateFromEdges(Edge edge) {
        this.fromEdges.put(edge.getFrom(), edge);
    }

    public boolean isSingleton() {
        return this.fromEdges.isEmpty() && this.toEdges.isEmpty();
    }

    public void removeToEdge(Edge edge) {
        this.toEdges.remove(edge.getTo());
    }

    public void removeFromEdge(Edge edge) {
        this.fromEdges.remove(edge.getFrom());
    }

    public Set<SAMRecord> getStartingReads() {
        return Collections.unmodifiableSet(this.startingReads);
    }
}

