/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.fastq;

import edu.unc.bioinf.ubu.fastq.FastqFormatterOptions;
import edu.unc.bioinf.ubu.fastq.FastqInputFile;
import edu.unc.bioinf.ubu.fastq.FastqOutputFile;
import edu.unc.bioinf.ubu.fastq.FastqRecord;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FastqFormatter {
    private FastqInputFile input;
    private FastqOutputFile output;
    private String idSuffix;
    private boolean shouldConvertPhred33To64;
    private boolean shouldStripAfterSpace;

    public FastqFormatter(FastqFormatterOptions options) throws FileNotFoundException, IOException {
        if (options.hasSuffix()) {
            this.idSuffix = options.getSuffix();
        }
        this.shouldConvertPhred33To64 = options.shouldConvertPhred33To64();
        this.shouldStripAfterSpace = options.shouldStripAfterWhitespace();
        this.input = new FastqInputFile();
        this.output = new FastqOutputFile();
        this.input.init(options.getInputFile());
        this.output.init(options.getOutputFile());
    }

    FastqFormatter(FastqInputFile input, FastqOutputFile output, String idSuffix, boolean shouldStripAfterSpace, boolean shouldConvertPhred33To64) {
        this.input = input;
        this.output = output;
        this.idSuffix = idSuffix;
        this.shouldConvertPhred33To64 = shouldConvertPhred33To64;
        this.shouldStripAfterSpace = shouldStripAfterSpace;
    }

    public void process() throws IOException {
        FastqRecord rec = this.input.getNextRecord();
        int count = 0;
        while (rec != null) {
            if (this.shouldStripAfterSpace) {
                rec.stripNonReadInfoInId();
            }
            if (this.idSuffix != null) {
                rec.appendToId(this.idSuffix);
            }
            if (this.shouldConvertPhred33To64) {
                rec.phred33To64();
            }
            this.output.write(rec);
            rec = this.input.getNextRecord();
            if (count++ % 1000000 != 0) continue;
            System.out.println("Processed " + count + " records.");
        }
        this.input.close();
        this.output.close();
        System.out.println("Done.");
    }

    public static void run(String[] args) throws IOException {
        FastqFormatterOptions options = new FastqFormatterOptions();
        options.parseOptions(args);
        if (options.isValid()) {
            FastqFormatter prep = new FastqFormatter(options);
            prep.process();
        }
    }
}

