/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.sam;

import edu.unc.bioinf.ubu.util.Options;
import joptsimple.OptionParser;

public class SamFileDiffOptions
extends Options {
    private static final String INPUT1 = "in1";
    private static final String INPUT2 = "in2";
    private static final String OUTPUT1 = "out1";
    private static final String OUTPUT2 = "out2";
    private static final String READ_ID_ONLY = "ids-only";
    private OptionParser parser;
    private boolean isValid;

    @Override
    protected OptionParser getOptionParser() {
        if (this.parser == null) {
            this.parser = new OptionParser();
            this.parser.accepts(INPUT1, "Input SAM/BAM file 1 sorted by read").withRequiredArg().ofType(String.class);
            this.parser.accepts(INPUT2, "Input SAM/BAM file 2 sorted by read").withRequiredArg().ofType(String.class);
            this.parser.accepts(OUTPUT1, "Output SAM/BAM file containing reads unique to input file 1").withRequiredArg().ofType(String.class);
            this.parser.accepts(OUTPUT2, "Output SAM/BAM file containing reads unique to input file 2").withRequiredArg().ofType(String.class);
            this.parser.accepts(READ_ID_ONLY, "If specified, compare read id only.  Otherwise, entire read is compared");
            this.parser.accepts("help", "Print this help message");
        }
        return this.parser;
    }

    @Override
    protected void validate() {
        this.isValid = true;
        if (!this.getOptions().hasArgument(INPUT1)) {
            this.isValid = false;
            System.err.println("Missing required input file 1");
        }
        if (!this.getOptions().hasArgument(INPUT2)) {
            this.isValid = false;
            System.err.println("Missing required input file 2");
        }
        if (!this.getOptions().hasArgument(OUTPUT1)) {
            this.isValid = false;
            System.err.println("Missing required output file 1");
        }
        if (!this.getOptions().hasArgument(OUTPUT2)) {
            this.isValid = false;
            System.err.println("Missing required output file 2");
        }
        if (!this.isValid) {
            this.printHelp();
        }
    }

    public String getInput1File() {
        return (String)this.getOptions().valueOf(INPUT1);
    }

    public String getInput2File() {
        return (String)this.getOptions().valueOf(INPUT2);
    }

    public String getOutput1File() {
        return (String)this.getOptions().valueOf(OUTPUT1);
    }

    public String getOutput2File() {
        return (String)this.getOptions().valueOf(OUTPUT2);
    }

    public boolean isReadIdComparisonOnly() {
        return this.getOptions().has(READ_ID_ONLY);
    }

    public boolean isValid() {
        return this.isValid;
    }
}

