/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.sam;

import edu.unc.bioinf.ubu.sam.ReadPair;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;

public class SamReadPairReader
implements Iterable<ReadPair> {
    private SAMRecord cachedRead;
    private SAMRecord lastRead;
    private Iterator<SAMRecord> iter;
    private int lineCnt = 0;
    private int readPairCacheIdx = Integer.MAX_VALUE;
    private List<ReadPair> readPairCache = new ArrayList<ReadPair>();
    private SAMFileReader inputSam;

    public SamReadPairReader(String filename) {
        File inputFile = new File(filename);
        this.inputSam = new SAMFileReader(inputFile);
        this.inputSam.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        this.iter = this.inputSam.iterator();
    }

    public void close() {
        this.inputSam.close();
    }

    public SAMFileHeader getHeader() {
        return this.inputSam.getFileHeader();
    }

    private List<ReadPair> pairReads(List<SAMRecord> reads1, List<SAMRecord> reads2) {
        HashSet<ReadPair> readPairSet = new HashSet<ReadPair>();
        ArrayList<ReadPair> readPairs = new ArrayList<ReadPair>();
        this.pairReads(reads1, reads2, readPairSet, readPairs);
        this.pairReads(reads2, reads1, readPairSet, readPairs);
        return readPairs;
    }

    private void pairReads(List<SAMRecord> reads1, List<SAMRecord> reads2, Set<ReadPair> readPairSet, List<ReadPair> readPairs) {
        HashMap<String, ArrayList<SAMRecord>> mate1Map = new HashMap<String, ArrayList<SAMRecord>>();
        for (SAMRecord read : reads1) {
            String key = read.getMateReferenceName() + "_" + read.getMateAlignmentStart();
            ArrayList<SAMRecord> readList = (ArrayList<SAMRecord>)mate1Map.get(key);
            if (readList == null) {
                readList = new ArrayList<SAMRecord>();
                mate1Map.put(key, readList);
            }
            readList.add(read);
        }
        for (SAMRecord read2 : reads2) {
            List readList = (List)mate1Map.get(read2.getReferenceName() + "_" + read2.getAlignmentStart());
            if (readList == null) continue;
            Iterator i$ = readList.iterator();
            while (i$.hasNext()) {
                ReadPair pair;
                SAMRecord read1;
                SAMRecord firstInPair = read1 = (SAMRecord)i$.next();
                SAMRecord secondInPair = read2;
                if (read1.getAlignmentStart() > read2.getAlignmentStart()) {
                    firstInPair = read2;
                    secondInPair = read1;
                }
                if (readPairSet.contains(pair = new ReadPair(firstInPair, secondInPair))) continue;
                readPairs.add(pair);
                readPairSet.add(pair);
            }
        }
    }

    private String getBaseName(SAMRecord read) {
        return read.getReadName().substring(0, read.getReadName().length() - 2);
    }

    private ReadPair getNextReadPair() {
        if (this.readPairCacheIdx < this.readPairCache.size()) {
            return this.readPairCache.get(this.readPairCacheIdx++);
        }
        while (this.hasMoreReads()) {
            this.readPairCache = this.getReadPairs();
            this.readPairCacheIdx = 0;
            if (this.readPairCache.size() <= 0) continue;
            return this.readPairCache.get(this.readPairCacheIdx++);
        }
        return null;
    }

    private boolean isCacheEmpty() {
        return this.readPairCacheIdx >= this.readPairCache.size();
    }

    private List<ReadPair> getReadPairs() {
        ArrayList<SAMRecord> reads1 = new ArrayList<SAMRecord>();
        ArrayList<SAMRecord> reads2 = new ArrayList<SAMRecord>();
        SAMRecord read = this.getNextRead();
        if (read != null) {
            String baseName = this.getBaseName(read);
            while (read != null && baseName.equals(this.getBaseName(read))) {
                if (read.getReadPairedFlag() && read.getFirstOfPairFlag()) {
                    reads1.add(read);
                } else if (read.getReadPairedFlag() && read.getSecondOfPairFlag()) {
                    reads2.add(read);
                }
                read = this.getNextRead();
            }
            if (read != null) {
                this.unGetRead();
            }
        }
        return this.pairReads(reads1, reads2);
    }

    private boolean hasMoreReads() {
        return this.cachedRead != null || this.iter.hasNext();
    }

    private SAMRecord getNextRead() {
        SAMRecord next = null;
        if (this.cachedRead != null) {
            next = this.cachedRead;
            this.cachedRead = null;
        } else if (this.iter.hasNext()) {
            next = this.iter.next();
            ++this.lineCnt;
            if (this.lineCnt % 1000000 == 0) {
                System.out.println("record: " + this.lineCnt);
            }
        } else {
            next = null;
        }
        this.lastRead = next;
        return next;
    }

    private void unGetRead() {
        this.cachedRead = this.lastRead;
    }

    @Override
    public Iterator<ReadPair> iterator() {
        return new ReadPairIterator(this);
    }

    public static void main(String[] args) {
        SamReadPairReader reader = new SamReadPairReader("/home/lisle/data/coord_convert/sorted_tiny.sam");
        for (ReadPair pair : reader) {
            System.out.println(pair);
        }
    }

    private static class ReadPairIterator
    implements Iterator<ReadPair> {
        private SamReadPairReader reader;
        private ReadPair nextReadPair = null;

        ReadPairIterator(SamReadPairReader reader) {
            this.reader = reader;
        }

        @Override
        public boolean hasNext() {
            if (this.nextReadPair == null && this.hasMoreReads()) {
                this.nextReadPair = this.reader.getNextReadPair();
            }
            return this.nextReadPair != null;
        }

        private boolean hasMoreReads() {
            return !this.reader.isCacheEmpty() || this.reader.hasMoreReads();
        }

        @Override
        public ReadPair next() {
            ReadPair pair = this.nextReadPair;
            this.nextReadPair = null;
            return pair;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported for ReadPairIterator.");
        }
    }
}

