/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.sam;

import edu.unc.bioinf.ubu.sam.ReadBlock;
import edu.unc.bioinf.ubu.sam.SamSummarizerOptions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;

public class SamSummarizer {
    private static final String EDIT_DISTANCE_TAG = "NM";
    private Map<String, ReferenceCounts> refCountMap = new HashMap<String, ReferenceCounts>();

    public void summarize(String inputFile, String outputFile, boolean shouldOutputHeader) throws IOException {
        long start = System.currentTimeMillis();
        BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile, false));
        File file = new File(inputFile);
        SAMFileReader inputSam = new SAMFileReader(file);
        inputSam.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        int count = 0;
        for (SAMRecord read : inputSam) {
            this.countRead(read);
            if (count++ % 1000000 != 0) continue;
            System.out.println("Processed " + count + " reads.");
        }
        if (shouldOutputHeader) {
            this.outputHeader(writer);
        }
        this.outputAllCounts(writer);
        writer.close();
        long stop = System.currentTimeMillis();
        System.out.println("free mem: " + Runtime.getRuntime().freeMemory());
        System.out.println("total mem: " + Runtime.getRuntime().totalMemory());
        System.out.println("Done.  Elapsed secs: " + (stop - start) / 1000L);
    }

    private void countRead(SAMRecord read) {
        int alignedBases = 0;
        if (!read.getReadUnmappedFlag()) {
            for (ReadBlock block : ReadBlock.getReadBlocks(read)) {
                if (block.getType() != CigarOperator.MATCH_OR_MISMATCH) continue;
                alignedBases += block.getLength();
            }
            Integer editDistance = read.getIntegerAttribute(EDIT_DISTANCE_TAG);
            ReferenceCounts counts = this.getReferenceCounts(read.getReferenceName());
            counts.incrementAlignedBases(alignedBases);
            if (editDistance != null) {
                counts.incrementEditDistanceCount(editDistance.intValue());
            }
            if (read.getMappingQuality() == 0) {
                counts.incrementMappingQualityZeroCount(1L);
            }
            counts.incrementReadCount(1L);
        }
    }

    private void outputAllCounts(BufferedWriter writer) throws IOException {
        ReferenceCounts totals = new ReferenceCounts();
        for (String ref : this.getSortedReferences()) {
            ReferenceCounts counts = this.getReferenceCounts(ref);
            this.outputCounts(counts, ref, writer);
            totals.incrementAlignedBases(counts.getAlignedBases());
            totals.incrementEditDistanceCount(counts.getEditDistanceCount());
            totals.incrementMappingQualityZeroCount(counts.getMappingQualityZeroCount());
            totals.incrementReadCount(counts.getReadCount());
        }
        this.outputCounts(totals, "Total", writer);
    }

    private void outputHeader(BufferedWriter writer) throws IOException {
        StringBuffer buf = new StringBuffer();
        buf.append("ref");
        buf.append('\t');
        buf.append("Aligned_Bases");
        buf.append('\t');
        buf.append(EDIT_DISTANCE_TAG);
        buf.append('\t');
        buf.append("Error_Rate");
        buf.append('\t');
        buf.append("Reads");
        buf.append('\t');
        buf.append("0_Mapping_Quality");
        buf.append('\t');
        buf.append("0_Mapping_Quality_Rate");
        buf.append('\n');
        writer.write(buf.toString());
    }

    private void outputCounts(ReferenceCounts counts, String ref, BufferedWriter writer) throws IOException {
        StringBuffer buf = new StringBuffer();
        buf.append(ref);
        buf.append('\t');
        buf.append(counts.getAlignedBases());
        buf.append('\t');
        buf.append(counts.getEditDistanceCount());
        buf.append('\t');
        buf.append(counts.getErrorRate());
        buf.append('\t');
        buf.append(counts.getReadCount());
        buf.append('\t');
        buf.append(counts.getMappingQualityZeroCount());
        buf.append('\t');
        buf.append(counts.getMappingQualityZeroRate());
        buf.append('\n');
        writer.write(buf.toString());
    }

    private List<String> getSortedReferences() {
        ArrayList<String> refs = new ArrayList<String>();
        refs.addAll(this.refCountMap.keySet());
        Collections.sort(refs);
        return Collections.unmodifiableList(refs);
    }

    private ReferenceCounts getReferenceCounts(String reference) {
        ReferenceCounts counts = this.refCountMap.get(reference);
        if (counts == null) {
            counts = new ReferenceCounts();
            this.refCountMap.put(reference, counts);
        }
        return counts;
    }

    public static void run(String[] args) throws IOException {
        SamSummarizerOptions options = new SamSummarizerOptions();
        options.parseOptions(args);
        if (options.isValid()) {
            new SamSummarizer().summarize(options.getInputFile(), options.getOutputFile(), options.shouldOutputHeader());
        }
    }

    public static void main(String[] args) throws IOException {
        SamSummarizer.run(args);
    }

    static class ReferenceCounts {
        private long alignedBases = 0L;
        private long editDistanceCount = 0L;
        private long mappingQualityZeroCount = 0L;
        private long readCount = 0L;

        ReferenceCounts() {
        }

        void incrementAlignedBases(long inc) {
            this.alignedBases += inc;
        }

        void incrementEditDistanceCount(long inc) {
            this.editDistanceCount += inc;
        }

        void incrementMappingQualityZeroCount(long inc) {
            this.mappingQualityZeroCount += inc;
        }

        void incrementReadCount(long inc) {
            this.readCount += inc;
        }

        long getAlignedBases() {
            return this.alignedBases;
        }

        long getEditDistanceCount() {
            return this.editDistanceCount;
        }

        double getErrorRate() {
            return (double)this.editDistanceCount / (double)this.alignedBases;
        }

        long getMappingQualityZeroCount() {
            return this.mappingQualityZeroCount;
        }

        long getReadCount() {
            return this.readCount;
        }

        double getMappingQualityZeroRate() {
            return (double)this.mappingQualityZeroCount / (double)this.readCount;
        }
    }
}

