/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import net.sf.samtools.SAMException;
import org.xerial.snappy.LoadSnappy;
import org.xerial.snappy.SnappyInputStream;

public class SnappyLoader {
    private static final int SNAPPY_BLOCK_SIZE = 32768;
    private final Constructor<InputStream> SnappyInputStreamCtor;
    private final Constructor<OutputStream> SnappyOutputStreamCtor;
    public final boolean SnappyAvailable;
    private final SnappyInputStream ignoreMe = null;
    private static final boolean DefaultVerbosity = Boolean.valueOf(System.getProperty("snappy.loader.verbosity", "false"));

    public SnappyLoader() {
        this(DefaultVerbosity);
    }

    public SnappyLoader(boolean verbose) {
        Constructor<?> inputStreamCtor = null;
        Constructor<?> outputStreamCtor = null;
        if (Boolean.valueOf(System.getProperty("snappy.disable", "false")).booleanValue()) {
            System.err.println("Snappy is disabled via system property.");
        } else {
            try {
                Class<?> snappyInputStreamClass = Class.forName("org.xerial.snappy.SnappyInputStream");
                Class<?> snappyOutputStreamClass = Class.forName("org.xerial.snappy.SnappyOutputStream");
                inputStreamCtor = snappyInputStreamClass.getConstructor(InputStream.class);
                outputStreamCtor = snappyOutputStreamClass.getConstructor(OutputStream.class, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        this.SnappyInputStreamCtor = inputStreamCtor;
        this.SnappyOutputStreamCtor = outputStreamCtor;
        if (this.SnappyInputStreamCtor != null && this.SnappyOutputStreamCtor != null) {
            if (!LoadSnappy.load()) {
                if (verbose) {
                    System.err.println("Snappy dll failed to load.");
                }
                this.SnappyAvailable = false;
            } else {
                if (verbose) {
                    System.err.println("Snappy stream classes loaded.");
                }
                this.SnappyAvailable = true;
            }
        } else {
            if (verbose) {
                System.err.println("Snappy stream classes not loaded.");
            }
            this.SnappyAvailable = false;
        }
    }

    public InputStream wrapInputStream(InputStream inputStream) {
        try {
            return this.SnappyInputStreamCtor.newInstance(inputStream);
        }
        catch (Exception e) {
            throw new SAMException("Error instantiating SnappyInputStream", e);
        }
    }

    public OutputStream wrapOutputStream(OutputStream outputStream) {
        try {
            return this.SnappyOutputStreamCtor.newInstance(outputStream, 32768);
        }
        catch (Exception e) {
            throw new SAMException("Error instantiating SnappyOutputStream", e);
        }
    }
}

