/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.commandline;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.SortedMap;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentException;
import org.broadinstitute.sting.commandline.ArgumentMatchSource;
import org.broadinstitute.sting.commandline.ArgumentTypeDescriptor;
import org.broadinstitute.sting.commandline.CommandLineUtils;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.ParsingEngine;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.help.ApplicationDetails;
import org.broadinstitute.sting.utils.help.HelpFormatter;

public abstract class CommandLineProgram {
    public ParsingEngine parser = null;
    @Argument(fullName="logging_level", shortName="l", doc="Set the minimum level of logging, i.e. setting INFO get's you INFO up to FATAL, setting ERROR gets you ERROR and FATAL level logging.", required=false)
    protected String logging_level = "INFO";
    @Output(fullName="log_to_file", shortName="log", doc="Set the logging location", required=false)
    protected String toFile = null;
    @Argument(fullName="help", shortName="h", doc="Generate this help message", required=false)
    public Boolean help = false;
    private static final String patternString = "%-5p %d{HH:mm:ss,SSS} %C{1} - %m %n";
    public static int result;

    protected ApplicationDetails getApplicationDetails() {
        return new ApplicationDetails(ApplicationDetails.createDefaultHeader(this.getClass()), Collections.<String>emptyList(), ApplicationDetails.createDefaultRunningInstructions(this.getClass()), null);
    }

    protected Collection<ArgumentTypeDescriptor> getArgumentTypeDescriptors() {
        return Collections.emptyList();
    }

    protected boolean canAddArgumentsDynamically() {
        return false;
    }

    protected Class[] getArgumentSources() {
        return new Class[0];
    }

    protected String getArgumentSourceName(Class source) {
        return source.toString();
    }

    public void setParser(ParsingEngine parser) {
        this.parser = parser;
    }

    protected abstract int execute() throws Exception;

    public static void start(CommandLineProgram clp, String[] args) throws Exception {
        CommandLineProgram.start(clp, args, false);
    }

    public static void start(CommandLineProgram clp, String[] args, boolean dryRun) throws Exception {
        block13: {
            try {
                SortedMap<ArgumentMatchSource, List<String>> parsedArgs;
                PatternLayout layout = new PatternLayout();
                Logger logger = CommandLineUtils.getStingLogger();
                CommandLineUtils.setLayout(logger, layout);
                clp.setupLoggerLevel(layout);
                ParsingEngine parser = clp.parser = new ParsingEngine(clp);
                parser.addArgumentSource(clp.getClass());
                if (clp.canAddArgumentsDynamically()) {
                    Class[] argumentSources;
                    parser.parse(args);
                    if (!dryRun) {
                        parser.validate(EnumSet.of(ParsingEngine.ValidationType.MissingRequiredArgument, ParsingEngine.ValidationType.InvalidArgument));
                    }
                    parser.loadArgumentsIntoObject(clp);
                    clp.setupLoggerLevel(layout);
                    for (Class argumentSource : argumentSources = clp.getArgumentSources()) {
                        parser.addArgumentSource(clp.getArgumentSourceName(argumentSource), argumentSource);
                    }
                    parsedArgs = parser.parse(args);
                    if (CommandLineProgram.isHelpPresent(parser)) {
                        CommandLineProgram.printHelpAndExit(clp, parser);
                    }
                    if (!dryRun) {
                        parser.validate();
                    }
                } else {
                    parsedArgs = parser.parse(args);
                    if (!dryRun) {
                        if (CommandLineProgram.isHelpPresent(parser)) {
                            CommandLineProgram.printHelpAndExit(clp, parser);
                        }
                        parser.validate();
                    }
                    parser.loadArgumentsIntoObject(clp);
                    clp.setupLoggerLevel(layout);
                }
                if (dryRun) break block13;
                if (clp.toFile != null) {
                    try {
                        FileAppender appender = new FileAppender(layout, clp.toFile, false);
                        logger.addAppender(appender);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unable to re-route log output to " + clp.toFile + " make sure the destination exists");
                    }
                }
                HelpFormatter.generateHeaderInformation(clp.getApplicationDetails(), parsedArgs);
                result = clp.execute();
            }
            catch (ArgumentException e) {
                clp.parser.printHelp(clp.getApplicationDetails());
                throw e;
            }
        }
    }

    public void loadArgumentsIntoObject(Object obj) {
        this.parser.loadArgumentsIntoObject(obj);
    }

    private void setupLoggerLevel(PatternLayout layout) {
        Level par;
        layout.setConversionPattern(patternString);
        if (this.logging_level.toUpperCase().equals("DEBUG")) {
            par = Level.DEBUG;
        } else if (this.logging_level.toUpperCase().equals("ERROR")) {
            par = Level.ERROR;
        } else if (this.logging_level.toUpperCase().equals("FATAL")) {
            par = Level.FATAL;
        } else if (this.logging_level.toUpperCase().equals("INFO")) {
            par = Level.INFO;
        } else if (this.logging_level.toUpperCase().equals("WARN")) {
            par = Level.WARN;
        } else if (this.logging_level.toUpperCase().equals("OFF")) {
            par = Level.OFF;
        } else {
            throw new ArgumentException("Unable to match: " + this.logging_level + " to a logging level, make sure it's a valid level (INFO, DEBUG, ERROR, FATAL, OFF)");
        }
        Logger.getRootLogger().setLevel(par);
    }

    private static void printDocumentationReference() {
        CommandLineProgram.errorPrintf("Visit our wiki for extensive documentation http://www.broadinstitute.org/gsa/wiki%n", new Object[0]);
        CommandLineProgram.errorPrintf("Visit our forum to view answers to commonly asked questions http://getsatisfaction.com/gsa%n", new Object[0]);
    }

    private static boolean isHelpPresent(ParsingEngine parser) {
        return parser.isArgumentPresent("help");
    }

    private static void printHelpAndExit(CommandLineProgram clp, ParsingEngine parser) {
        parser.printHelp(clp.getApplicationDetails());
        System.exit(0);
    }

    private static void errorPrintf(String format, Object ... s) {
        String formatted = String.format(format, s);
        if (formatted.trim().equals("")) {
            System.err.println("##### ERROR");
        } else {
            for (String part : formatted.split("\n")) {
                System.err.println("##### ERROR " + part);
            }
        }
    }

    public static void exitSystemWithError(String msg, Throwable t) {
        CommandLineProgram.errorPrintf("------------------------------------------------------------------------------------------%n", new Object[0]);
        CommandLineProgram.errorPrintf("stack trace %n", new Object[0]);
        t.printStackTrace();
        CommandLineProgram.errorPrintf("------------------------------------------------------------------------------------------%n", new Object[0]);
        CommandLineProgram.errorPrintf("A GATK RUNTIME ERROR has occurred (version %s):%n", CommandLineGATK.getVersionNumber());
        CommandLineProgram.errorPrintf("%n", new Object[0]);
        CommandLineProgram.errorPrintf("Please visit the wiki to see if this is a known problem%n", new Object[0]);
        CommandLineProgram.errorPrintf("If not, please post the error, with stack trace, to the GATK forum%n", new Object[0]);
        CommandLineProgram.printDocumentationReference();
        if (msg == null) {
            msg = "Code exception (see stack trace for error itself)";
        }
        CommandLineProgram.errorPrintf("%n", new Object[0]);
        CommandLineProgram.errorPrintf("MESSAGE: %s%n", msg.trim());
        CommandLineProgram.errorPrintf("------------------------------------------------------------------------------------------%n", new Object[0]);
        System.exit(1);
    }

    public static void exitSystemWithUserError(Exception e) {
        if (e.getMessage() == null) {
            throw new ReviewedStingException("UserException found with no message!", e);
        }
        CommandLineProgram.errorPrintf("------------------------------------------------------------------------------------------%n", new Object[0]);
        CommandLineProgram.errorPrintf("A USER ERROR has occurred (version %s): %n", CommandLineGATK.getVersionNumber());
        CommandLineProgram.errorPrintf("The invalid arguments or inputs must be corrected before the GATK can proceed%n", new Object[0]);
        CommandLineProgram.errorPrintf("Please do not post this error to the GATK forum%n", new Object[0]);
        CommandLineProgram.errorPrintf("%n", new Object[0]);
        CommandLineProgram.errorPrintf("See the documentation (rerun with -h) for this tool to view allowable command-line arguments.%n", new Object[0]);
        CommandLineProgram.printDocumentationReference();
        CommandLineProgram.errorPrintf("%n", new Object[0]);
        CommandLineProgram.errorPrintf("MESSAGE: %s%n", e.getMessage().trim());
        CommandLineProgram.errorPrintf("------------------------------------------------------------------------------------------%n", new Object[0]);
        System.exit(1);
    }

    public static void exitSystemWithSamError(Exception e) {
        if (e.getMessage() == null) {
            throw new ReviewedStingException("SamException found with no message!", e);
        }
        CommandLineProgram.errorPrintf("------------------------------------------------------------------------------------------%n", new Object[0]);
        CommandLineProgram.errorPrintf("A BAM ERROR has occurred (version %s): %n", CommandLineGATK.getVersionNumber());
        CommandLineProgram.errorPrintf("The invalid inputs must be corrected before the GATK can proceed%n", new Object[0]);
        CommandLineProgram.errorPrintf("Please do not post this error to the GATK forum until you have followed the instructions below%n", new Object[0]);
        CommandLineProgram.errorPrintf("%n", new Object[0]);
        CommandLineProgram.errorPrintf("Please make sure that your BAM file is well-formed by running Picard's validator on it%n", new Object[0]);
        CommandLineProgram.errorPrintf("(see http://picard.sourceforge.net/command-line-overview.shtml#ValidateSamFile for details)%n", new Object[0]);
        CommandLineProgram.errorPrintf("Also, please ensure that your BAM index is not corrupted: delete the current one and regenerate it with 'samtools index'%n", new Object[0]);
        CommandLineProgram.printDocumentationReference();
        CommandLineProgram.errorPrintf("%n", new Object[0]);
        CommandLineProgram.errorPrintf("MESSAGE: %s%n", e.getMessage().trim());
        CommandLineProgram.errorPrintf("------------------------------------------------------------------------------------------%n", new Object[0]);
        System.exit(1);
    }

    public static void exitSystemWithError(Throwable t) {
        CommandLineProgram.exitSystemWithError(t.getMessage(), t);
    }

    protected static void forceJVMLocaleToUSEnglish() {
        Locale.setDefault(Locale.US);
    }

    static {
        CommandLineProgram.forceJVMLocaleToUSEnglish();
        CommandLineUtils.configureConsoleLogging();
        result = -1;
    }
}

