/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.StingException;

public class FileHandleCache {
    private final FileHandleStorage fileHandleStorage;
    private final int cacheSize;
    private final Map<SAMReaderID, Integer> keyCounter = new HashMap<SAMReaderID, Integer>();
    private final Object lock = new Object();
    private int numOutstandingFileHandles = 0;

    public FileHandleCache(int cacheSize) {
        this.cacheSize = cacheSize;
        this.fileHandleStorage = new FileHandleStorage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileInputStream claimFileInputStream(SAMReaderID key) {
        Object object = this.lock;
        synchronized (object) {
            FileInputStream inputStream = this.findExistingEntry(key);
            if (inputStream == null) {
                try {
                    if (this.numOutstandingFileHandles >= this.cacheSize) {
                        this.lock.wait();
                    }
                }
                catch (InterruptedException ex) {
                    throw new ReviewedStingException("Interrupted while waiting for a file handle");
                }
                inputStream = this.openInputStream(key);
            }
            ++this.numOutstandingFileHandles;
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseFileInputStream(SAMReaderID key, FileInputStream inputStream) {
        Object object = this.lock;
        synchronized (object) {
            --this.numOutstandingFileHandles;
            UniqueKey newID = this.allocateKey(key);
            this.fileHandleStorage.put(newID, inputStream);
            this.lock.notify();
        }
    }

    private FileInputStream findExistingEntry(SAMReaderID key) {
        int existingHandles = this.getMostRecentUniquifier(key);
        for (int i = 0; i <= existingHandles; ++i) {
            UniqueKey uniqueKey = new UniqueKey(key, i);
            if (!this.fileHandleStorage.containsKey(uniqueKey)) continue;
            return (FileInputStream)this.fileHandleStorage.remove(uniqueKey);
        }
        return null;
    }

    private int getMostRecentUniquifier(SAMReaderID reader) {
        if (this.keyCounter.containsKey(reader)) {
            return this.keyCounter.get(reader);
        }
        return -1;
    }

    private UniqueKey allocateKey(SAMReaderID reader) {
        int uniquifier = this.getMostRecentUniquifier(reader) + 1;
        this.keyCounter.put(reader, uniquifier);
        return new UniqueKey(reader, uniquifier);
    }

    private FileInputStream openInputStream(SAMReaderID reader) {
        try {
            return new FileInputStream(reader.getSamFilePath());
        }
        catch (IOException ex) {
            throw new StingException("Unable to open input file");
        }
    }

    private void closeInputStream(FileInputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException ex) {
            throw new StingException("Unable to open input file");
        }
    }

    private class UniqueKey {
        private final SAMReaderID key;
        private final int uniqueID;

        public UniqueKey(SAMReaderID reader, int uniqueID) {
            this.key = reader;
            this.uniqueID = uniqueID;
        }

        public boolean equals(Object other) {
            if (!(other instanceof UniqueKey)) {
                return false;
            }
            UniqueKey otherUniqueKey = (UniqueKey)other;
            return this.key.equals(otherUniqueKey.key) && this.uniqueID == otherUniqueKey.uniqueID;
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    private class FileHandleStorage
    extends LinkedHashMap<UniqueKey, FileInputStream> {
        private FileHandleStorage() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean removeEldestEntry(Map.Entry<UniqueKey, FileInputStream> entry) {
            Object object = FileHandleCache.this.lock;
            synchronized (object) {
                if (this.size() > FileHandleCache.this.cacheSize) {
                    FileHandleCache.this.keyCounter.put(entry.getKey().key, (Integer)FileHandleCache.this.keyCounter.get(entry.getKey().key) - 1);
                    FileHandleCache.this.closeInputStream(entry.getValue());
                    return true;
                }
            }
            return false;
        }
    }
}

