/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.TribbleException;
import org.broad.tribble.readers.AsciiLineReader;
import org.broad.tribble.util.Positional;

class FeatureIterator
implements Iterator<Feature>,
Iterable<Feature>,
Positional {
    private AsciiLineReader reader;
    private Feature nextFeature;
    private final FeatureCodec codec;
    private final File inputFile;
    private long cachedPosition;

    public FeatureIterator(File inputFile, FeatureCodec codec) {
        FileInputStream is = null;
        this.codec = codec;
        this.inputFile = inputFile;
        try {
            is = new FileInputStream(inputFile);
        }
        catch (FileNotFoundException e) {
            throw new TribbleException.FeatureFileDoesntExist("Unable to open the input file, most likely the file doesn't exist.", inputFile.getAbsolutePath());
        }
        this.reader = new AsciiLineReader(is);
        codec.readHeader(this.reader);
        this.cachedPosition = 0L;
        this.readNextFeature();
    }

    @Override
    public boolean hasNext() {
        return this.nextFeature != null;
    }

    @Override
    public Feature next() {
        Feature ret = this.nextFeature;
        this.readNextFeature();
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("We cannot remove");
    }

    @Override
    public Iterator<Feature> iterator() {
        return this;
    }

    @Override
    public long getPosition() {
        return this.hasNext() ? this.cachedPosition : this.reader.getPosition();
    }

    private void readNextFeature() {
        this.cachedPosition = this.reader.getPosition();
        try {
            String nextLine = null;
            do {
                this.nextFeature = (nextLine = this.reader.readLine()) != null ? this.codec.decodeLoc(nextLine) : null;
            } while (this.nextFeature == null && nextLine != null);
        }
        catch (IOException e) {
            throw new TribbleException.MalformedFeatureFile("Unable to read a line from the file", this.inputFile.getAbsolutePath(), e);
        }
    }
}

