/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.sam;

import edu.unc.bioinf.ubu.util.Options;
import joptsimple.OptionParser;

public class GenomeToTranscriptomeOptions
extends Options {
    private static final String BED_FILE = "bed";
    private static final String READ_OFFSET = "offset";
    private static final String INPUT_ALIGNMENT_FILE = "in";
    private static final String OUTPUT_ALIGNMENT_FILE = "out";
    private static final String ORDERING_FASTA = "order";
    private static final String REVERSE_STRAND_COORDS = "reverse";
    private static final String OUTPUT_XG_TAGS = "xgtags";
    private static final String SINGLE_END = "single";
    private static final int DEFAULT_READ_OFFSET = 25;
    private OptionParser parser;
    private boolean isValid = false;

    @Override
    protected OptionParser getOptionParser() {
        if (this.parser == null) {
            this.parser = new OptionParser();
            this.parser.accepts(BED_FILE, "Bed file definition of isoforms").withRequiredArg().ofType(String.class);
            this.parser.accepts(INPUT_ALIGNMENT_FILE, "Input alignment file").withRequiredArg().ofType(String.class);
            this.parser.accepts(OUTPUT_ALIGNMENT_FILE, "Output alignment file").withRequiredArg().ofType(String.class);
            this.parser.accepts(READ_OFFSET, "Optional Offset size of read index (default 25)").withRequiredArg().ofType(Integer.class);
            this.parser.accepts(ORDERING_FASTA, "Optional FASTA file used to determine order of isoforms in BAM header (important for RSEM)").withRequiredArg().ofType(String.class);
            this.parser.accepts(REVERSE_STRAND_COORDS, "Optional flag indicating that reverse strand coordinates should be reported");
            this.parser.accepts(OUTPUT_XG_TAGS, "Optional flag indicating that genomic coordinates should be output in a XG tag");
            this.parser.accepts(SINGLE_END, "Optional flag indicating that reads need not be paired in the same transcript to be output (default is off)");
            this.parser.accepts("help", "Print this help message");
        }
        return this.parser;
    }

    @Override
    protected void validate() {
        this.isValid = true;
        if (!this.getOptions().hasArgument(BED_FILE)) {
            this.isValid = false;
            System.err.println("Missing required bed file");
        }
        if (!this.getOptions().hasArgument(INPUT_ALIGNMENT_FILE)) {
            this.isValid = false;
            System.err.println("Missing required input alignment file");
        }
        if (!this.getOptions().hasArgument(OUTPUT_ALIGNMENT_FILE)) {
            this.isValid = false;
            System.err.println("Missing required output alignment file");
        }
        if (!this.isValid) {
            this.printHelp();
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String getBedFile() {
        return (String)this.getOptions().valueOf(BED_FILE);
    }

    public int getReadOffset() {
        int readOffset = 25;
        if (this.getOptions().hasArgument(READ_OFFSET)) {
            readOffset = (Integer)this.getOptions().valueOf(READ_OFFSET);
        }
        return readOffset;
    }

    public String getInputAlignmentFile() {
        return (String)this.getOptions().valueOf(INPUT_ALIGNMENT_FILE);
    }

    public String getOutputAlignmentFile() {
        return (String)this.getOptions().valueOf(OUTPUT_ALIGNMENT_FILE);
    }

    public String getOrderingFastaFile() {
        return (String)this.getOptions().valueOf(ORDERING_FASTA);
    }

    public boolean hasOrderingFastaFile() {
        return this.getOptions().hasArgument(ORDERING_FASTA);
    }

    public boolean isPositiveStrandReportingOnly() {
        return !this.getOptions().has(REVERSE_STRAND_COORDS);
    }

    public boolean shouldOutputXgTags() {
        return this.getOptions().has(OUTPUT_XG_TAGS);
    }

    public boolean isSingleEnd() {
        return this.getOptions().has(SINGLE_END);
    }
}

