/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.sam;

import edu.unc.bioinf.ubu.sam.Coordinate;
import edu.unc.bioinf.ubu.sam.Isoform;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;

public class IsoformIndex {
    private int readOffset;
    private String currentIndexedChromosome = "unset";
    private MultiHashMap indexMap;
    private Map<String, List<Isoform>> chromosomeIsoformsMap = new HashMap<String, List<Isoform>>();
    private Map<String, Isoform> isoformMap = new HashMap<String, Isoform>();

    private List<Coordinate> getExonCoordinates(int isoformStart, String exonLengths, String exonOffsets) {
        String[] offsets;
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        String[] lengths = exonLengths.split(",");
        if (lengths.length != (offsets = exonOffsets.split(",")).length) {
            throw new IllegalArgumentException("Invalid exon length offset pairing: [" + exonLengths + "] [" + exonOffsets + "]");
        }
        for (int i = 0; i < lengths.length; ++i) {
            int start = isoformStart;
            int stop = (start += Integer.parseInt(offsets[i])) + Integer.parseInt(lengths[i]) - 1;
            coordinates.add(new Coordinate(start, stop));
        }
        return coordinates;
    }

    public void buildReadToIsoformIndex(String filename, int readOffset) throws Exception {
        this.readOffset = readOffset;
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        String line = reader.readLine();
        int cnt = 1;
        while (line != null) {
            String[] fields = line.split("\\s+");
            String chromosome = fields[0];
            int start = Integer.valueOf(fields[1]) + 1;
            int end = Integer.valueOf(fields[2]) + 1;
            String isoformId = fields[3];
            String strand = fields[5];
            String exonLengths = fields[10];
            String exonOffsets = fields[11];
            if (cnt++ % 10000 == 0) {
                System.out.println("Loaded " + cnt + " isoforms.");
            }
            Isoform isoform = new Isoform(isoformId, new Coordinate(start, end), strand, this.getExonCoordinates(start, exonLengths, exonOffsets));
            this.isoformMap.put(isoformId, isoform);
            List<Isoform> isoforms = this.chromosomeIsoformsMap.get(chromosome);
            if (isoforms == null) {
                isoforms = new ArrayList<Isoform>();
                this.chromosomeIsoformsMap.put(chromosome, isoforms);
            }
            isoforms.add(isoform);
            line = reader.readLine();
        }
    }

    public Collection<Isoform> getAllIsoforms() {
        return Collections.unmodifiableCollection(this.isoformMap.values());
    }

    private MultiMap getIndexMap(String chromosome) {
        if (!this.currentIndexedChromosome.equals(chromosome)) {
            System.out.println("Indexing isoforms for: " + chromosome);
            this.currentIndexedChromosome = chromosome;
            this.indexMap = new MultiHashMap();
            List<Isoform> isoformsInChromosome = this.chromosomeIsoformsMap.get(chromosome);
            if (isoformsInChromosome != null) {
                for (Isoform isoform : isoformsInChromosome) {
                    int start = isoform.getGenomicCoordinate().getStart();
                    int end = isoform.getGenomicCoordinate().getStop();
                    int startIdx = start - start % this.readOffset;
                    int endIdx = end + (this.readOffset - end % this.readOffset);
                    for (int idx = startIdx; idx <= endIdx; idx += this.readOffset) {
                        this.indexMap.put((Object)idx, isoform.getIsoformId());
                    }
                }
            }
        }
        return this.indexMap;
    }

    private Collection<String> getPotentialIsoformsExact(String chromosome, int genomeStart) {
        Collection isoformCol;
        Collection isoforms = Collections.EMPTY_LIST;
        MultiMap map = this.getIndexMap(chromosome);
        if (map != null && (isoformCol = (Collection)map.get(genomeStart)) != null) {
            isoforms = isoformCol;
        }
        return isoforms;
    }

    public Collection<String> getPotentialIsoforms(String chromosome, int genomePosition) {
        HashSet<String> isoforms = new HashSet<String>();
        isoforms.addAll(this.getPotentialIsoformsExact(chromosome, genomePosition - genomePosition % this.readOffset));
        isoforms.addAll(this.getPotentialIsoformsExact(chromosome, genomePosition + (this.readOffset - genomePosition % this.readOffset)));
        return Collections.unmodifiableCollection(isoforms);
    }

    public Isoform getIsoform(String isoformId) {
        return this.isoformMap.get(isoformId);
    }

    public static void main(String[] args) throws Exception {
        long s = System.currentTimeMillis();
        IsoformIndex rdr = new IsoformIndex();
        rdr.buildReadToIsoformIndex("/home/lisle/data/coord_convert/ucsc_known_gene_bed.txt", 200);
        long e = System.currentTimeMillis();
        System.out.println("elapsed secs: " + (e - s) / 1000L);
        System.out.println(rdr.getPotentialIsoforms("chr22", 30000000));
    }
}

