#include <stdio.h>
#include <unistd.h>
#include <assert.h>
#include <fcntl.h>
#include "bam.h"

#ifdef _USE_KNETFILE
#include "knetfile.h"
#endif

int bam_taf2baf(int argc, char *argv[]);
int bam_pileup(int argc, char *argv[]);
int bam_mpileup(int argc, char *argv[]);
int bam_merge(int argc, char *argv[]);
int bam_index(int argc, char *argv[]);
int bam_sort(int argc, char *argv[]);
int bam_tview_main(int argc, char *argv[]);
int bam_mating(int argc, char *argv[]);
int bam_rmdup(int argc, char *argv[]);
int bam_flagstat(int argc, char *argv[]);
int bam_fillmd(int argc, char *argv[]);
int bam_idxstats(int argc, char *argv[]);
int main_samview(int argc, char *argv[]);
int main_import(int argc, char *argv[]);
int main_reheader(int argc, char *argv[]);
int main_cut_target(int argc, char *argv[]);
int main_phase(int argc, char *argv[]);
int main_cat(int argc, char *argv[]);
int main_depth(int argc, char *argv[]);

int faidx_main(int argc, char *argv[]);
int glf3_view_main(int argc, char *argv[]);

static int usage()
{
	fprintf(stderr, "\n");
	fprintf(stderr, "Program: samtools (Tools for alignments in the SAM format)\n");
	fprintf(stderr, "Version: %s\n\n", BAM_VERSION);
	fprintf(stderr, "Usage:   samtools <command> [options]\n\n");
	fprintf(stderr, "Command: view        SAM<->BAM conversion\n");
	fprintf(stderr, "         sort        sort alignment file\n");
	fprintf(stderr, "         pileup      generate pileup output\n");
	fprintf(stderr, "         mpileup     multi-way pileup\n");
	fprintf(stderr, "         depth       compute the depth\n");
	fprintf(stderr, "         faidx       index/extract FASTA\n");
#if _CURSES_LIB != 0
	fprintf(stderr, "         tview       text alignment viewer\n");
#endif
	fprintf(stderr, "         index       index alignment\n");
	fprintf(stderr, "         idxstats    BAM index stats (r595 or later)\n");
	fprintf(stderr, "         fixmate     fix mate information\n");
	fprintf(stderr, "         glfview     print GLFv3 file\n");
	fprintf(stderr, "         flagstat    simple stats\n");
	fprintf(stderr, "         calmd       recalculate MD/NM tags and '=' bases\n");
	fprintf(stderr, "         merge       merge sorted alignments\n");
	fprintf(stderr, "         rmdup       remove PCR duplicates\n");
	fprintf(stderr, "         reheader    replace BAM header\n");
	fprintf(stderr, "         cat         concatenate BAMs\n");
	fprintf(stderr, "         targetcut   cut fosmid regions (for fosmid pool only)\n");
	fprintf(stderr, "         phase       phase heterozygotes\n");
	fprintf(stderr, "\n");
#ifdef _WIN32
	fprintf(stderr, "\
Note: The Windows version of SAMtools is mainly designed for read-only\n\
      operations, such as viewing the alignments and generating the pileup.\n\
      Binary files generated by the Windows version may be buggy.\n\n");
#endif
	return 1;
}

int main(int argc, char *argv[])
{
#ifdef _WIN32
	setmode(fileno(stdout), O_BINARY);
	setmode(fileno(stdin),  O_BINARY);
#ifdef _USE_KNETFILE
	knet_win32_init();
#endif
#endif
	if (argc < 2) return usage();
	if (strcmp(argv[1], "view") == 0) return main_samview(argc-1, argv+1);
	else if (strcmp(argv[1], "import") == 0) return main_import(argc-1, argv+1);
	else if (strcmp(argv[1], "pileup") == 0) return bam_pileup(argc-1, argv+1);
	else if (strcmp(argv[1], "mpileup") == 0) return bam_mpileup(argc-1, argv+1);
	else if (strcmp(argv[1], "merge") == 0) return bam_merge(argc-1, argv+1);
	else if (strcmp(argv[1], "sort") == 0) return bam_sort(argc-1, argv+1);
	else if (strcmp(argv[1], "index") == 0) return bam_index(argc-1, argv+1);
	else if (strcmp(argv[1], "idxstats") == 0) return bam_idxstats(argc-1, argv+1);
	else if (strcmp(argv[1], "faidx") == 0) return faidx_main(argc-1, argv+1);
	else if (strcmp(argv[1], "fixmate") == 0) return bam_mating(argc-1, argv+1);
	else if (strcmp(argv[1], "rmdup") == 0) return bam_rmdup(argc-1, argv+1);
	else if (strcmp(argv[1], "glfview") == 0) return glf3_view_main(argc-1, argv+1);
	else if (strcmp(argv[1], "flagstat") == 0) return bam_flagstat(argc-1, argv+1);
	else if (strcmp(argv[1], "calmd") == 0) return bam_fillmd(argc-1, argv+1);
	else if (strcmp(argv[1], "fillmd") == 0) return bam_fillmd(argc-1, argv+1);
	else if (strcmp(argv[1], "reheader") == 0) return main_reheader(argc-1, argv+1);
	else if (strcmp(argv[1], "cat") == 0) return main_cat(argc-1, argv+1);
	else if (strcmp(argv[1], "targetcut") == 0) return main_cut_target(argc-1, argv+1);
	else if (strcmp(argv[1], "phase") == 0) return main_phase(argc-1, argv+1);
	else if (strcmp(argv[1], "depth") == 0) return main_depth(argc-1, argv+1);
#if _CURSES_LIB != 0
	else if (strcmp(argv[1], "tview") == 0) return bam_tview_main(argc-1, argv+1);
#endif
	else {
		fprintf(stderr, "[main] unrecognized command '%s'\n", argv[1]);
		return 1;
	}
	return 0;	
}
