/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.IOException;
import java.io.InputStream;
import net.sf.samtools.util.LineReader;
import net.sf.samtools.util.RuntimeIOException;

public class AsciiLineReaderImpl
implements LineReader {
    private static final char LINEFEED = '\n';
    private static final char CARRIAGE_RETURN = '\r';
    private final InputStream is;
    private byte[] buffer;
    private int nextChar;
    private int nChars;
    private char[] lineBuffer = new char[10000];
    private int lineNumber = 0;

    public AsciiLineReaderImpl(InputStream is) {
        this(is, 512000);
    }

    public AsciiLineReaderImpl(InputStream is, int bufferSize) {
        this.is = is;
        this.buffer = new byte[bufferSize];
        this.nChars = 0;
        this.nextChar = 0;
    }

    @Override
    public String readLine() {
        return this.readLine(false);
    }

    public String readLine(boolean includeTerminators) {
        int linePosition = 0;
        while (this.nChars != -1) {
            char c;
            if (this.nextChar == this.nChars) {
                this.fill();
                if (this.nextChar == this.nChars || this.nChars == -1) {
                    if (linePosition > 0) {
                        ++this.lineNumber;
                        return new String(this.lineBuffer, 0, linePosition);
                    }
                    return null;
                }
            }
            if ((c = (char)(this.buffer[this.nextChar++] & 0xFF)) == '\n' || c == '\r') {
                if (includeTerminators) {
                    this.lineBuffer[linePosition++] = c;
                    if (c == '\r' && this.peek() == 10) {
                        this.lineBuffer[linePosition++] = c;
                        ++this.nextChar;
                    }
                } else if (c == '\r' && this.peek() == 10) {
                    ++this.nextChar;
                }
                ++this.lineNumber;
                return new String(this.lineBuffer, 0, linePosition);
            }
            if (linePosition > this.lineBuffer.length - 3) {
                char[] temp = new char[this.lineBuffer.length + 1000];
                System.arraycopy(this.lineBuffer, 0, temp, 0, this.lineBuffer.length);
                this.lineBuffer = temp;
            }
            this.lineBuffer[linePosition++] = c;
        }
        return null;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int peek() {
        if (this.nextChar == this.nChars) {
            this.fill();
            if (this.nextChar == this.nChars) {
                return -1;
            }
        }
        return this.buffer[this.nextChar];
    }

    private void fill() {
        try {
            this.nChars = this.is.read(this.buffer);
            this.nextChar = 0;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

