/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.commandline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.broadinstitute.sting.commandline.ArgumentDefinition;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class ArgumentDefinitionGroup
implements Iterable<ArgumentDefinition> {
    public final String groupName;
    public final List<ArgumentDefinition> argumentDefinitions;

    public ArgumentDefinitionGroup(String groupName, List<ArgumentDefinition> argumentDefinitions) {
        this.groupName = groupName;
        this.argumentDefinitions = Collections.unmodifiableList(argumentDefinitions);
    }

    public boolean groupNameMatches(ArgumentDefinitionGroup other) {
        if (this.groupName == null && other.groupName == null) {
            return true;
        }
        if (this.groupName == null && other.groupName != null) {
            return false;
        }
        return this.groupName.equals(other.groupName);
    }

    public ArgumentDefinitionGroup merge(ArgumentDefinitionGroup other) {
        if (!this.groupNameMatches(other)) {
            throw new ReviewedStingException("Unable to merge two argument groups with differing names.");
        }
        ArrayList<ArgumentDefinition> mergedDefinitions = new ArrayList<ArgumentDefinition>();
        mergedDefinitions.addAll(this.argumentDefinitions);
        mergedDefinitions.addAll(other.argumentDefinitions);
        return new ArgumentDefinitionGroup(this.groupName, mergedDefinitions);
    }

    @Override
    public Iterator<ArgumentDefinition> iterator() {
        return this.argumentDefinitions.iterator();
    }

    public boolean allHidden() {
        for (ArgumentDefinition argumentDefinition : this.argumentDefinitions) {
            if (argumentDefinition.isHidden) continue;
            return false;
        }
        return true;
    }
}

