/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.providers;

import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.datasources.providers.ReferenceView;
import org.broadinstitute.sting.gatk.datasources.providers.ShardDataProvider;
import org.broadinstitute.sting.utils.GenomeLoc;

public class ReadReferenceView
extends ReferenceView {
    public ReadReferenceView(ShardDataProvider provider) {
        super(provider);
    }

    protected ReferenceContext.ReferenceContextRefProvider getReferenceBasesProvider(GenomeLoc genomeLoc) {
        return new Provider(genomeLoc);
    }

    public ReferenceContext getReferenceContext(SAMRecord read) {
        GenomeLoc loc = this.genomeLocParser.createGenomeLoc(read);
        return new ReferenceContext(this.genomeLocParser, loc, loc, this.getReferenceBasesProvider(loc));
    }

    public class Provider
    implements ReferenceContext.ReferenceContextRefProvider {
        GenomeLoc loc;

        public Provider(GenomeLoc loc) {
            this.loc = loc;
        }

        @Override
        public byte[] getBases() {
            return ReadReferenceView.this.getReferenceBases(this.loc);
        }
    }
}

