/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.IntervalBinding;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.filters.DuplicateReadFilter;
import org.broadinstitute.sting.gatk.filters.FailsVendorQualityCheckFilter;
import org.broadinstitute.sting.gatk.filters.NotPrimaryAlignmentFilter;
import org.broadinstitute.sting.gatk.filters.UnmappedReadFilter;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.ActiveRegionExtension;
import org.broadinstitute.sting.gatk.walkers.By;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.PartitionBy;
import org.broadinstitute.sting.gatk.walkers.PartitionType;
import org.broadinstitute.sting.gatk.walkers.ReadFilters;
import org.broadinstitute.sting.gatk.walkers.Requires;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.GenomeLocSortedSet;
import org.broadinstitute.sting.utils.activeregion.ActiveRegion;
import org.broadinstitute.sting.utils.interval.IntervalMergingRule;
import org.broadinstitute.sting.utils.interval.IntervalSetRule;
import org.broadinstitute.sting.utils.interval.IntervalUtils;

@By(value=DataSource.READS)
@Requires(value={DataSource.READS, DataSource.REFERENCE_BASES})
@PartitionBy(value=PartitionType.READ)
@ActiveRegionExtension(extension=50)
@ReadFilters(value={UnmappedReadFilter.class, NotPrimaryAlignmentFilter.class, DuplicateReadFilter.class, FailsVendorQualityCheckFilter.class})
public abstract class ActiveRegionWalker<MapType, ReduceType>
extends Walker<MapType, ReduceType> {
    @Output(fullName="activeRegionOut", shortName="ARO", doc="Output the active region to this interval list file", required=false)
    public PrintStream activeRegionOutStream = null;
    @Input(fullName="activeRegionIn", shortName="AR", doc="Use this interval list file as the active regions to process", required=false)
    protected List<IntervalBinding<Feature>> activeRegionBindings = null;
    public GenomeLocSortedSet presetActiveRegions = null;

    @Override
    public void initialize() {
        if (this.activeRegionBindings == null) {
            return;
        }
        List<GenomeLoc> allIntervals = new ArrayList<GenomeLoc>(0);
        for (IntervalBinding<Feature> intervalBinding : this.activeRegionBindings) {
            List<GenomeLoc> intervals = intervalBinding.getIntervals(this.getToolkit());
            if (intervals.isEmpty()) {
                logger.warn("The interval file " + intervalBinding.getSource() + " contains no intervals that could be parsed.");
            }
            allIntervals = IntervalUtils.mergeListsBySetOperator(intervals, allIntervals, IntervalSetRule.UNION);
        }
        this.presetActiveRegions = IntervalUtils.sortAndMergeIntervals(this.getToolkit().getGenomeLocParser(), allIntervals, IntervalMergingRule.ALL);
    }

    public boolean filter(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        return true;
    }

    public boolean wantsNonPrimaryReads() {
        return false;
    }

    public abstract double isActive(RefMetaDataTracker var1, ReferenceContext var2, AlignmentContext var3);

    public abstract MapType map(ActiveRegion var1, RefMetaDataTracker var2);

    public final GenomeLocSortedSet extendIntervals(GenomeLocSortedSet intervals, GenomeLocParser genomeLocParser, IndexedFastaSequenceFile reference) {
        int activeRegionExtension = this.getClass().getAnnotation(ActiveRegionExtension.class).extension();
        ArrayList<GenomeLoc> allIntervals = new ArrayList<GenomeLoc>();
        for (GenomeLoc interval : intervals.toList()) {
            int start = Math.max(1, interval.getStart() - activeRegionExtension);
            int stop = Math.min(reference.getSequenceDictionary().getSequence(interval.getContig()).getSequenceLength(), interval.getStop() + activeRegionExtension);
            allIntervals.add(genomeLocParser.createGenomeLoc(interval.getContig(), start, stop));
        }
        return IntervalUtils.sortAndMergeIntervals(genomeLocParser, allIntervals, IntervalMergingRule.ALL);
    }
}

