/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import java.util.List;
import org.broadinstitute.sting.utils.QualityUtils;

public class RecalDatumOptimized {
    protected long numObservations;
    protected long numMismatches;

    public RecalDatumOptimized() {
        this.numObservations = 0L;
        this.numMismatches = 0L;
    }

    public RecalDatumOptimized(long _numObservations, long _numMismatches) {
        this.numObservations = _numObservations;
        this.numMismatches = _numMismatches;
    }

    public RecalDatumOptimized(RecalDatumOptimized copy) {
        this.numObservations = copy.numObservations;
        this.numMismatches = copy.numMismatches;
    }

    public final synchronized void increment(long incObservations, long incMismatches) {
        this.numObservations += incObservations;
        this.numMismatches += incMismatches;
    }

    public final synchronized void increment(RecalDatumOptimized other) {
        this.increment(other.numObservations, other.numMismatches);
    }

    public final synchronized void increment(List<RecalDatumOptimized> data) {
        for (RecalDatumOptimized other : data) {
            this.increment(other);
        }
    }

    public final double empiricalQualDouble(int smoothing, double maxQual) {
        double doubleMismatches = this.numMismatches + (long)smoothing;
        double doubleObservations = this.numObservations + (long)smoothing;
        double empiricalQual = -10.0 * Math.log10(doubleMismatches / doubleObservations);
        return Math.min(empiricalQual, maxQual);
    }

    public final byte empiricalQualByte(int smoothing) {
        double doubleMismatches = this.numMismatches + (long)smoothing;
        double doubleObservations = this.numObservations + (long)smoothing;
        return QualityUtils.probToQual(1.0 - doubleMismatches / doubleObservations);
    }

    public final byte empiricalQualByte() {
        return this.empiricalQualByte(0);
    }

    public final String outputToCSV() {
        return String.format("%d,%d,%d", this.numObservations, this.numMismatches, (int)this.empiricalQualByte());
    }
}

