/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.recalibration;

import java.util.Arrays;
import org.broadinstitute.sting.gatk.walkers.recalibration.ExperimentalCovariate;
import org.broadinstitute.sting.gatk.walkers.recalibration.RecalibrationArgumentCollection;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class ContextCovariate
implements ExperimentalCovariate {
    private int CONTEXT_SIZE;
    private String allN = "";

    @Override
    public void initialize(RecalibrationArgumentCollection RAC) {
        this.CONTEXT_SIZE = RAC.CONTEXT_SIZE;
        if (this.CONTEXT_SIZE <= 0) {
            throw new UserException("Context Size must be positive, if you don't want to use the context covariate, just turn it off instead");
        }
        for (int i = 0; i < this.CONTEXT_SIZE; ++i) {
            this.allN = this.allN + "N";
        }
    }

    @Override
    public void getValues(GATKSAMRecord read, Comparable[] comparable) {
        byte[] bases = read.getReadBases();
        for (int i = 0; i < read.getReadLength(); ++i) {
            comparable[i] = i < this.CONTEXT_SIZE ? this.allN : new String(Arrays.copyOfRange(bases, i - this.CONTEXT_SIZE, i));
        }
    }

    @Override
    public final Comparable getValue(String str) {
        return str;
    }
}

