/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.recalibration;

import org.broadinstitute.sting.gatk.walkers.recalibration.RecalDatumOptimized;

public class RecalDatum
extends RecalDatumOptimized {
    private double estimatedQReported;
    private double empiricalQuality;

    public RecalDatum() {
        this.numObservations = 0L;
        this.numMismatches = 0L;
        this.estimatedQReported = 0.0;
        this.empiricalQuality = 0.0;
    }

    public RecalDatum(long _numObservations, long _numMismatches, double _estimatedQReported, double _empiricalQuality) {
        this.numObservations = _numObservations;
        this.numMismatches = _numMismatches;
        this.estimatedQReported = _estimatedQReported;
        this.empiricalQuality = _empiricalQuality;
    }

    public RecalDatum(RecalDatum copy) {
        this.numObservations = copy.numObservations;
        this.numMismatches = copy.numMismatches;
        this.estimatedQReported = copy.estimatedQReported;
        this.empiricalQuality = copy.empiricalQuality;
    }

    public final void combine(RecalDatum other) {
        double sumErrors = this.calcExpectedErrors() + other.calcExpectedErrors();
        this.increment(other.numObservations, other.numMismatches);
        this.estimatedQReported = -10.0 * Math.log10(sumErrors / (double)this.numObservations);
    }

    public final void calcCombinedEmpiricalQuality(int smoothing, int maxQual) {
        this.empiricalQuality = this.empiricalQualDouble(smoothing, maxQual);
    }

    public final double getEstimatedQReported() {
        return this.estimatedQReported;
    }

    public final double getEmpiricalQuality() {
        return this.empiricalQuality;
    }

    private double calcExpectedErrors() {
        return (double)this.numObservations * this.qualToErrorProb(this.estimatedQReported);
    }

    private double qualToErrorProb(double qual) {
        return Math.pow(10.0, qual / -10.0);
    }
}

