/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.variantcontext;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.MapContext;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;
import org.broadinstitute.sting.utils.variantcontext.VariantJEXLContext;

class JEXLMap
implements Map<VariantContextUtils.JexlVCMatchExp, Boolean> {
    private final VariantContext vc;
    private final Genotype g;
    private JexlContext jContext = null;
    private Map<VariantContextUtils.JexlVCMatchExp, Boolean> jexl;

    public JEXLMap(Collection<VariantContextUtils.JexlVCMatchExp> jexlCollection, VariantContext vc, Genotype g) {
        this.vc = vc;
        this.g = g;
        this.initialize(jexlCollection);
    }

    public JEXLMap(Collection<VariantContextUtils.JexlVCMatchExp> jexlCollection, VariantContext vc) {
        this(jexlCollection, vc, null);
    }

    private void initialize(Collection<VariantContextUtils.JexlVCMatchExp> jexlCollection) {
        this.jexl = new HashMap<VariantContextUtils.JexlVCMatchExp, Boolean>();
        for (VariantContextUtils.JexlVCMatchExp exp : jexlCollection) {
            this.jexl.put(exp, null);
        }
    }

    private void createContext() {
        if (this.g == null) {
            this.jContext = new VariantJEXLContext(this.vc);
        } else {
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            if (this.vc != null) {
                infoMap.put("CHROM", this.vc.getChr());
                infoMap.put("POS", this.vc.getStart());
                infoMap.put("TYPE", this.vc.getType().toString());
                infoMap.put("QUAL", String.valueOf(this.vc.getPhredScaledQual()));
                infoMap.put("ALLELES", Utils.join(";", this.vc.getAlleles()));
                infoMap.put("N_ALLELES", String.valueOf(this.vc.getNAlleles()));
                JEXLMap.addAttributesToMap(infoMap, this.vc.getAttributes());
                infoMap.put("FILTER", this.vc.isFiltered() ? "1" : "0");
                for (String string : this.vc.getFilters()) {
                    infoMap.put(String.valueOf(string), "1");
                }
                infoMap.put("GT", this.g.getGenotypeString());
                infoMap.put("isHomRef", this.g.isHomRef() ? "1" : "0");
                infoMap.put("isHet", this.g.isHet() ? "1" : "0");
                infoMap.put("isHomVar", this.g.isHomVar() ? "1" : "0");
                infoMap.put("GQ", new Double(this.g.getPhredScaledQual()));
                for (Map.Entry entry : this.g.getAttributes().entrySet()) {
                    if (entry.getValue() == null || entry.getValue().equals(".")) continue;
                    infoMap.put((String)entry.getKey(), entry.getValue());
                }
            }
            this.jContext = new MapContext(infoMap);
        }
    }

    @Override
    public int size() {
        return this.jexl.size();
    }

    @Override
    public boolean isEmpty() {
        return this.jexl.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.jexl.containsKey(o);
    }

    @Override
    public Boolean get(Object o) {
        if (this.jexl.containsKey(o) && this.jexl.get(o) != null) {
            return this.jexl.get(o);
        }
        VariantContextUtils.JexlVCMatchExp e = (VariantContextUtils.JexlVCMatchExp)o;
        this.evaluateExpression(e);
        return this.jexl.get(e);
    }

    @Override
    public Set<VariantContextUtils.JexlVCMatchExp> keySet() {
        return this.jexl.keySet();
    }

    @Override
    public Collection<Boolean> values() {
        for (VariantContextUtils.JexlVCMatchExp exp : this.jexl.keySet()) {
            if (this.jexl.get(exp) != null) continue;
            this.evaluateExpression(exp);
        }
        return this.jexl.values();
    }

    private void evaluateExpression(VariantContextUtils.JexlVCMatchExp exp) {
        if (this.jContext == null) {
            this.createContext();
        }
        try {
            this.jexl.put(exp, (Boolean)exp.exp.evaluate(this.jContext));
        }
        catch (Exception e) {
            throw new UserException.CommandLineException(String.format("Invalid JEXL expression detected for %s with message %s", exp.name, e.getMessage()));
        }
    }

    private static void addAttributesToMap(Map<String, Object> infoMap, Map<String, ?> attributes) {
        for (Map.Entry<String, ?> e : attributes.entrySet()) {
            infoMap.put(e.getKey(), String.valueOf(e.getValue()));
        }
    }

    @Override
    public Boolean put(VariantContextUtils.JexlVCMatchExp jexlVCMatchExp, Boolean aBoolean) {
        return this.jexl.put(jexlVCMatchExp, aBoolean);
    }

    @Override
    public void putAll(Map<? extends VariantContextUtils.JexlVCMatchExp, ? extends Boolean> map) {
        this.jexl.putAll(map);
    }

    @Override
    public boolean containsValue(Object o) {
        throw new UnsupportedOperationException("containsValue() not supported on a JEXLMap");
    }

    @Override
    public Boolean remove(Object o) {
        throw new UnsupportedOperationException("remove() not supported on a JEXLMap");
    }

    @Override
    public Set<Map.Entry<VariantContextUtils.JexlVCMatchExp, Boolean>> entrySet() {
        throw new UnsupportedOperationException("clear() not supported on a JEXLMap");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear() not supported on a JEXLMap");
    }
}

