/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import org.broadinstitute.sting.gatk.datasources.providers.View;
import org.broadinstitute.sting.gatk.datasources.reads.Shard;
import org.broadinstitute.sting.gatk.datasources.rmd.ReferenceOrderedDataSource;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public abstract class ShardDataProvider {
    private List<View> registeredViews = new ArrayList<View>();
    private final Shard shard;
    private final GenomeLocParser genomeLocParser;
    private final IndexedFastaSequenceFile reference;
    private final Collection<ReferenceOrderedDataSource> referenceOrderedData;

    public GenomeLocParser getGenomeLocParser() {
        return this.genomeLocParser;
    }

    public Shard getShard() {
        return this.shard;
    }

    public boolean hasReference() {
        return this.reference != null;
    }

    IndexedFastaSequenceFile getReference() {
        return this.reference;
    }

    Collection<ReferenceOrderedDataSource> getReferenceOrderedData() {
        return this.referenceOrderedData;
    }

    public ShardDataProvider(Shard shard, GenomeLocParser genomeLocParser, IndexedFastaSequenceFile reference, Collection<ReferenceOrderedDataSource> rods) {
        this.shard = shard;
        this.genomeLocParser = genomeLocParser;
        this.reference = reference;
        this.referenceOrderedData = rods;
    }

    ShardDataProvider(Shard shard, GenomeLocParser genomeLocParser) {
        this(shard, genomeLocParser, null, null);
    }

    void register(View view) {
        for (View view2 : this.registeredViews) {
            Collection<Class<? extends View>> conflicts = view2.getConflictingViews();
            for (Class<? extends View> conflict : conflicts) {
                if (!conflict.isInstance(view)) continue;
                throw new ReviewedStingException(String.format("Tried to register two conflicting views: %s and %s", view2.getClass().getSimpleName(), view.getClass().getSimpleName()));
            }
        }
        for (Class clazz : view.getConflictingViews()) {
            for (View registeredView : this.registeredViews) {
                if (!clazz.isInstance(registeredView)) continue;
                throw new ReviewedStingException(String.format("Tried to register two conflicting views: %s and %s", registeredView.getClass().getSimpleName(), view.getClass().getSimpleName()));
            }
        }
        this.registeredViews.add(view);
    }

    public void close() {
        for (View view : this.registeredViews) {
            view.close();
        }
        this.registeredViews.clear();
        if (this.shard != null) {
            this.shard.close();
        }
    }

    public String toString() {
        return this.shard.toString();
    }
}

