/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.samples;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.sting.gatk.samples.Affection;
import org.broadinstitute.sting.gatk.samples.Gender;
import org.broadinstitute.sting.gatk.samples.SampleDB;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class Sample
implements Comparable<Sample> {
    private final String familyID;
    private final String paternalID;
    private final String maternalID;
    private final Gender gender;
    private final String otherPhenotype;
    private final Affection affection;
    private final String ID;
    private final SampleDB infoDB;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    public static final String UNSET_QT = null;

    public Sample(String ID, SampleDB infoDB, String familyID, String paternalID, String maternalID, Gender gender, Affection affection, String otherPhenotype) {
        this.familyID = familyID;
        this.paternalID = paternalID;
        this.maternalID = maternalID;
        this.gender = gender;
        this.otherPhenotype = otherPhenotype;
        this.affection = affection;
        this.ID = ID;
        this.infoDB = infoDB;
    }

    protected Sample(String ID, String familyID, String paternalID, String maternalID, Gender gender, Affection affection, String otherPhenotype) {
        this(ID, null, familyID, paternalID, maternalID, gender, affection, otherPhenotype);
    }

    protected Sample(String ID, String familyID, String paternalID, String maternalID, Gender gender, Affection affection) {
        this(ID, null, familyID, paternalID, maternalID, gender, affection, UNSET_QT);
    }

    public Sample(String ID, SampleDB infoDB, String familyID, String paternalID, String maternalID, Gender gender) {
        this(ID, infoDB, familyID, paternalID, maternalID, gender, Affection.UNKNOWN, UNSET_QT);
    }

    public Sample(String ID, SampleDB infoDB, Affection affection, String otherPhenotype) {
        this(ID, infoDB, null, null, null, Gender.UNKNOWN, affection, otherPhenotype);
    }

    public Sample(String id, SampleDB infoDB) {
        this(id, infoDB, null, null, null, Gender.UNKNOWN, Affection.UNKNOWN, UNSET_QT);
    }

    public String getID() {
        return this.ID;
    }

    public String getFamilyID() {
        return this.familyID;
    }

    public String getPaternalID() {
        return this.paternalID;
    }

    public String getMaternalID() {
        return this.maternalID;
    }

    public Affection getAffection() {
        return this.affection;
    }

    public boolean hasOtherPhenotype() {
        return this.affection == Affection.OTHER;
    }

    public String getOtherPhenotype() {
        return this.otherPhenotype;
    }

    public Sample getMother() {
        return this.infoDB.getSample(this.maternalID);
    }

    public Sample getFather() {
        return this.infoDB.getSample(this.paternalID);
    }

    public ArrayList<Sample> getParents() {
        ArrayList<Sample> parents = new ArrayList<Sample>(2);
        Sample parent = this.getMother();
        if (parent != null) {
            parents.add(parent);
        }
        if ((parent = this.getFather()) != null) {
            parents.add(parent);
        }
        return parents;
    }

    public Gender getGender() {
        return this.gender;
    }

    @Override
    public int compareTo(Sample sample) {
        return this.ID.compareTo(sample.getID());
    }

    public String toString() {
        return String.format("Sample %s fam=%s dad=%s mom=%s gender=%s affection=%s qt=%s props=%s", new Object[]{this.getID(), this.getFamilyID(), this.getPaternalID(), this.getMaternalID(), this.getGender(), this.getAffection(), this.getOtherPhenotype(), this.properties});
    }

    public int hashCode() {
        return this.ID.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Sample) {
            Sample otherSample = (Sample)o;
            return this.ID.equals(otherSample.ID) && Sample.equalOrNull(this.familyID, otherSample.familyID) && Sample.equalOrNull(this.paternalID, otherSample.paternalID) && Sample.equalOrNull(this.maternalID, otherSample.maternalID) && Sample.equalOrNull((Object)this.gender, (Object)otherSample.gender) && Sample.equalOrNull(this.otherPhenotype, otherSample.otherPhenotype) && Sample.equalOrNull((Object)this.affection, (Object)otherSample.affection) && Sample.equalOrNull(this.properties, otherSample.properties);
        }
        return false;
    }

    private static final boolean equalOrNull(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o2 == null ? false : o1.equals(o2);
    }

    private static final <T> T mergeValues(String name, String field, T o1, T o2, T emptyValue) {
        if (o1 == null || o1.equals(emptyValue)) {
            return o2 == null ? null : (T)o2;
        }
        if (o2 == null || o2.equals(emptyValue)) {
            return o1;
        }
        if (o1 == o2) {
            return o1;
        }
        throw new UserException("Inconsistent values detected for " + name + " for field " + field + " value1 " + o1 + " value2 " + o2);
    }

    public static final Sample mergeSamples(Sample prev, Sample next) {
        if (prev.equals(next)) {
            return next;
        }
        return new Sample(prev.getID(), prev.infoDB, Sample.mergeValues(prev.getID(), "Family_ID", prev.getFamilyID(), next.getFamilyID(), null), Sample.mergeValues(prev.getID(), "Paternal_ID", prev.getPaternalID(), next.getPaternalID(), null), Sample.mergeValues(prev.getID(), "Material_ID", prev.getMaternalID(), next.getMaternalID(), null), Sample.mergeValues(prev.getID(), "Gender", prev.getGender(), next.getGender(), Gender.UNKNOWN), Sample.mergeValues(prev.getID(), "Affection", prev.getAffection(), next.getAffection(), Affection.UNKNOWN), Sample.mergeValues(prev.getID(), "OtherPhenotype", prev.getOtherPhenotype(), next.getOtherPhenotype(), UNSET_QT));
    }
}

