/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.sam;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class IsoformOrderLoader {
    private Map<String, Integer> isoformOrderMap;
    private static final char ISOFORM_INDICATOR = '>';

    public void loadOrdering(String filename) throws FileNotFoundException, IOException {
        this.isoformOrderMap = new HashMap<String, Integer>();
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        String line = reader.readLine();
        int cnt = 1;
        while (line != null) {
            if (line.length() < 2) {
                throw new IllegalArgumentException("Invalid entry [" + line + "] in file [" + filename + "]");
            }
            if (line.charAt(0) == '>') {
                String isoformId = line.substring(1, line.length());
                this.isoformOrderMap.put(isoformId, cnt);
                ++cnt;
            }
            line = reader.readLine();
        }
        System.out.println("Ordering loaded for " + cnt + " isosforms.");
        reader.close();
    }

    public Integer getOrder(String isoformId) {
        if (this.isoformOrderMap == null) {
            throw new IllegalStateException("Isoform order map not initialized.");
        }
        Integer order = this.isoformOrderMap.get(isoformId);
        if (order == null) {
            order = Integer.MAX_VALUE;
        }
        return order;
    }

    public void clearCache() {
        this.isoformOrderMap = null;
    }
}

