/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.sam;

import edu.unc.bioinf.ubu.util.Options;
import joptsimple.OptionParser;

public class SpliceJunctionCounterOptions
extends Options {
    private static final String INPUT = "in";
    private static final String OUTPUT = "out";
    private static final String JUNCTION_FILE = "junctions";
    private OptionParser parser;
    private boolean isValid;

    @Override
    protected OptionParser getOptionParser() {
        if (this.parser == null) {
            this.parser = new OptionParser();
            this.parser.accepts(INPUT, "Input SAM/BAM file").withRequiredArg().ofType(String.class);
            this.parser.accepts(OUTPUT, "Output file containing junction counts").withRequiredArg().ofType(String.class);
            this.parser.accepts(JUNCTION_FILE, "Input list of junctions defined in a format similar to: chr1:12227:+,chr1:12595:+").withRequiredArg().ofType(String.class);
            this.parser.accepts("help", "Print this help message");
        }
        return this.parser;
    }

    @Override
    protected void validate() {
        this.isValid = true;
        if (!this.getOptions().hasArgument(INPUT)) {
            this.isValid = false;
            System.err.println("Missing required input file 1");
        }
        if (!this.getOptions().hasArgument(OUTPUT)) {
            this.isValid = false;
            System.err.println("Missing required input file 2");
        }
        if (!this.getOptions().hasArgument(JUNCTION_FILE)) {
            this.isValid = false;
            System.err.println("Missing required input junction file");
        }
        if (!this.isValid) {
            this.printHelp();
        }
    }

    public String getInputFile() {
        return (String)this.getOptions().valueOf(INPUT);
    }

    public String getOutputFile() {
        return (String)this.getOptions().valueOf(OUTPUT);
    }

    public String getJunctionFile() {
        return (String)this.getOptions().valueOf(JUNCTION_FILE);
    }

    public boolean isValid() {
        return this.isValid;
    }
}

