/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.samtools.SAMFileSpan;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.ReadMetrics;
import org.broadinstitute.sting.gatk.ReadProperties;
import org.broadinstitute.sting.gatk.datasources.reads.SAMDataSource;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.gatk.iterators.StingSAMIterator;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.HasGenomeLocation;

public abstract class Shard
implements HasGenomeLocation {
    protected final GenomeLocParser parser;
    protected final ShardType shardType;
    protected final List<GenomeLoc> locs;
    private final boolean isUnmapped;
    private final SAMDataSource readsDataSource;
    private final Map<SAMReaderID, SAMFileSpan> fileSpans;
    protected final ReadMetrics readMetrics = new ReadMetrics();

    public boolean isUnmapped() {
        return this.isUnmapped;
    }

    public Shard(GenomeLocParser parser, ShardType shardType, List<GenomeLoc> locs, SAMDataSource readsDataSource, Map<SAMReaderID, SAMFileSpan> fileSpans, boolean isUnmapped) {
        this.locs = locs;
        this.parser = parser;
        this.shardType = shardType;
        this.readsDataSource = readsDataSource;
        this.fileSpans = fileSpans;
        this.isUnmapped = isUnmapped;
    }

    public List<GenomeLoc> getGenomeLocs() {
        return this.locs;
    }

    public Map<SAMReaderID, SAMFileSpan> getFileSpans() {
        return Collections.unmodifiableMap(this.fileSpans);
    }

    @Override
    public GenomeLoc getLocation() {
        if (this.getGenomeLocs() == null) {
            return GenomeLoc.WHOLE_GENOME;
        }
        int start = Integer.MAX_VALUE;
        int stop = Integer.MIN_VALUE;
        String contig = null;
        for (GenomeLoc loc : this.getGenomeLocs()) {
            if (GenomeLoc.isUnmapped(loc)) {
                return loc;
            }
            contig = loc.getContig();
            if (loc.getStart() < start) {
                start = loc.getStart();
            }
            if (loc.getStop() <= stop) continue;
            stop = loc.getStop();
        }
        return this.parser.createGenomeLoc(contig, start, stop);
    }

    public ShardType getShardType() {
        return this.shardType;
    }

    public void close() {
        this.readsDataSource.incorporateReadMetrics(this.readMetrics);
    }

    public ReadProperties getReadProperties() {
        return this.readsDataSource.getReadsInfo();
    }

    public ReadMetrics getReadMetrics() {
        return this.readMetrics;
    }

    public boolean buffersReads() {
        return false;
    }

    public boolean isBufferEmpty() {
        throw new UnsupportedOperationException("This shard does not buffer reads.");
    }

    public boolean isBufferFull() {
        throw new UnsupportedOperationException("This shard does not buffer reads.");
    }

    public void addRead(SAMRecord read) {
        throw new UnsupportedOperationException("This shard does not buffer reads.");
    }

    public StingSAMIterator iterator() {
        throw new UnsupportedOperationException("This shard does not buffer reads.");
    }

    public static enum ShardType {
        READ,
        LOCUS;

    }
}

