/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.text;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class XReadLines
implements Iterator<String>,
Iterable<String> {
    private BufferedReader in;
    private String nextline = null;
    private boolean trimWhitespace = true;

    public XReadLines(File filename, boolean trimWhitespace) throws FileNotFoundException {
        this(new FileReader(filename), trimWhitespace);
    }

    public XReadLines(File filename) throws FileNotFoundException {
        this(filename, true);
    }

    public XReadLines(FileReader fileReader, boolean trimWhitespace) throws FileNotFoundException {
        this(new BufferedReader(fileReader), trimWhitespace);
    }

    public XReadLines(FileReader fileReader) throws FileNotFoundException {
        this(fileReader, true);
    }

    public XReadLines(InputStream inputStream, boolean trimWhitespace) {
        this(new BufferedReader(new InputStreamReader(inputStream)), trimWhitespace);
    }

    public XReadLines(InputStream inputStream) throws FileNotFoundException {
        this(inputStream, true);
    }

    public XReadLines(Reader reader, boolean trimWhitespace) {
        try {
            this.in = new BufferedReader(reader);
            this.nextline = this.readNextLine();
            this.trimWhitespace = trimWhitespace;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public XReadLines(Reader reader) {
        this(reader, true);
    }

    public List<String> readLines() {
        LinkedList<String> lines = new LinkedList<String>();
        for (String line : this) {
            lines.add(line);
        }
        return lines;
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.nextline != null;
    }

    private String readNextLine() throws IOException {
        String nextline = this.in.readLine();
        if (nextline != null && this.trimWhitespace) {
            nextline = nextline.trim();
        }
        return nextline;
    }

    @Override
    public String next() {
        try {
            String result = this.nextline;
            this.nextline = this.readNextLine();
            if (this.nextline == null) {
                this.in.close();
            }
            return result;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        this.in.close();
    }
}

