/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.io.stubs;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import org.broadinstitute.sting.gatk.CommandLineExecutable;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.io.OutputTracker;
import org.broadinstitute.sting.gatk.io.stubs.Stub;
import org.broadinstitute.sting.utils.classloader.JVMUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class VCFWriterStub
implements Stub<VCFWriter>,
VCFWriter {
    private final GenomeAnalysisEngine engine;
    private final File genotypeFile;
    private final PrintStream genotypeStream;
    private VCFHeader vcfHeader = null;
    private final boolean isCompressed;
    private final Collection<Object> argumentSources;
    private final boolean skipWritingHeader;
    private final boolean doNotWriteGenotypes;
    protected OutputTracker outputTracker = null;

    public VCFWriterStub(GenomeAnalysisEngine engine, File genotypeFile, boolean isCompressed, Collection<Object> argumentSources, boolean skipWritingHeader, boolean doNotWriteGenotypes) {
        this.engine = engine;
        this.genotypeFile = genotypeFile;
        this.genotypeStream = null;
        this.isCompressed = isCompressed;
        this.argumentSources = argumentSources;
        this.skipWritingHeader = skipWritingHeader;
        this.doNotWriteGenotypes = doNotWriteGenotypes;
    }

    public VCFWriterStub(GenomeAnalysisEngine engine, OutputStream genotypeStream, boolean isCompressed, Collection<Object> argumentSources, boolean skipWritingHeader, boolean doNotWriteGenotypes) {
        this.engine = engine;
        this.genotypeFile = null;
        this.genotypeStream = new PrintStream(genotypeStream);
        this.isCompressed = isCompressed;
        this.argumentSources = argumentSources;
        this.skipWritingHeader = skipWritingHeader;
        this.doNotWriteGenotypes = doNotWriteGenotypes;
    }

    public File getFile() {
        return this.genotypeFile;
    }

    public PrintStream getOutputStream() {
        return this.genotypeStream;
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public SAMSequenceDictionary getMasterSequenceDictionary() {
        return this.engine.getMasterSequenceDictionary();
    }

    public boolean doNotWriteGenotypes() {
        return this.doNotWriteGenotypes;
    }

    public VCFHeader getVCFHeader() {
        return this.vcfHeader;
    }

    @Override
    public void register(OutputTracker outputTracker) {
        this.outputTracker = outputTracker;
    }

    @Override
    public void writeHeader(VCFHeader header) {
        this.vcfHeader = header;
        if (!this.skipWritingHeader) {
            VCFHeaderLine commandLineArgHeaderLine = this.getCommandLineArgumentHeaderLine();
            boolean foundCommandLineHeaderLine = false;
            for (VCFHeaderLine line : this.vcfHeader.getMetaData()) {
                if (!line.getKey().equals(commandLineArgHeaderLine.getKey())) continue;
                foundCommandLineHeaderLine = true;
            }
            if (!foundCommandLineHeaderLine) {
                this.vcfHeader.addMetaDataLine(commandLineArgHeaderLine);
            }
            String assembly = this.getReferenceAssembly(this.engine.getArguments().referenceFile.getName());
            for (SAMSequenceRecord contig : this.engine.getReferenceDataSource().getReference().getSequenceDictionary().getSequences()) {
                this.vcfHeader.addMetaDataLine(this.getContigHeaderLine(contig, assembly));
            }
            this.vcfHeader.addMetaDataLine(new VCFHeaderLine("reference", "file://" + this.engine.getArguments().referenceFile.getAbsolutePath()));
        }
        this.outputTracker.getStorage(this).writeHeader(this.vcfHeader);
    }

    @Override
    public void add(VariantContext vc) {
        this.outputTracker.getStorage(this).add(vc);
    }

    @Override
    public void close() {
        this.outputTracker.getStorage(this).close();
    }

    public String toString() {
        return this.getClass().getName();
    }

    private VCFHeaderLine getCommandLineArgumentHeaderLine() {
        CommandLineExecutable executable = JVMUtils.getObjectOfType(this.argumentSources, CommandLineExecutable.class);
        return new VCFHeaderLine(executable.getAnalysisName(), "\"" + this.engine.createApproximateCommandLineArgumentString(this.argumentSources.toArray()) + "\"");
    }

    private VCFHeaderLine getContigHeaderLine(SAMSequenceRecord contig, String assembly) {
        String val = assembly != null ? String.format("<ID=%s,length=%d,assembly=%s>", contig.getSequenceName(), contig.getSequenceLength(), assembly) : String.format("<ID=%s,length=%d>", contig.getSequenceName(), contig.getSequenceLength());
        return new VCFHeaderLine("contig", val);
    }

    private String getReferenceAssembly(String refPath) {
        String assembly = null;
        if (refPath.indexOf("b37") != -1 || refPath.indexOf("v37") != -1) {
            assembly = "b37";
        } else if (refPath.indexOf("b36") != -1) {
            assembly = "b36";
        } else if (refPath.indexOf("hg18") != -1) {
            assembly = "hg18";
        } else if (refPath.indexOf("hg19") != -1) {
            assembly = "hg19";
        }
        return assembly;
    }
}

