/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.recalibration;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.broadinstitute.sting.gatk.walkers.bqsr.Covariate;
import org.broadinstitute.sting.gatk.walkers.bqsr.CovariateKeySet;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalDataManager;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalDatum;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalibrationArgumentCollection;
import org.broadinstitute.sting.utils.QualityUtils;
import org.broadinstitute.sting.utils.classloader.PluginManager;
import org.broadinstitute.sting.utils.collections.NestedHashMap;
import org.broadinstitute.sting.utils.exceptions.DynamicClassResolutionException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.text.XReadLines;

public class BaseRecalibration {
    private RecalDataManager dataManager;
    private final ArrayList<Covariate> requestedCovariates = new ArrayList();
    public static final Pattern COMMENT_PATTERN = Pattern.compile("^#.*");
    public static final Pattern COVARIATE_PATTERN = Pattern.compile("^ReadGroup,QualityScore,.*");
    public static final String EOF_MARKER = "EOF";
    private static final int MAX_QUALITY_SCORE = 65;
    private NestedHashMap qualityScoreByFullCovariateKey = new NestedHashMap();

    public BaseRecalibration(File RECAL_FILE) {
        List<Class<Covariate>> classes = new PluginManager<Covariate>(Covariate.class).getPlugins();
        int lineNumber = 0;
        boolean foundAllCovariates = false;
        boolean sawEOF = false;
        try {
            for (String line : new XReadLines(RECAL_FILE)) {
                ++lineNumber;
                if (EOF_MARKER.equals(line)) {
                    sawEOF = true;
                    continue;
                }
                if (COMMENT_PATTERN.matcher(line).matches()) continue;
                if (COVARIATE_PATTERN.matcher(line).matches()) {
                    if (foundAllCovariates) {
                        throw new UserException.MalformedFile(RECAL_FILE, "Malformed input recalibration file. Found covariate names intermingled with data in file: " + RECAL_FILE);
                    }
                    String[] vals = line.split(",");
                    for (int iii = 0; iii < vals.length - 4; ++iii) {
                        boolean foundClass = false;
                        for (Class<Covariate> covClass : classes) {
                            if (!(vals[iii] + "Covariate").equalsIgnoreCase(covClass.getSimpleName())) continue;
                            foundClass = true;
                            try {
                                Covariate covariate = covClass.newInstance();
                                this.requestedCovariates.add(covariate);
                            }
                            catch (Exception e) {
                                throw new DynamicClassResolutionException(covClass, e);
                            }
                        }
                        if (foundClass) continue;
                        throw new UserException.MalformedFile(RECAL_FILE, "Malformed input recalibration file. The requested covariate type (" + vals[iii] + "Covariate" + ") isn't a valid covariate option.");
                    }
                    continue;
                }
                if (!foundAllCovariates) {
                    foundAllCovariates = true;
                    if (this.requestedCovariates.size() < 2) {
                        throw new UserException.MalformedFile(RECAL_FILE, "Malformed input recalibration csv file. Covariate names can't be found in file: " + RECAL_FILE);
                    }
                    boolean createCollapsedTables = true;
                    RecalibrationArgumentCollection RAC = new RecalibrationArgumentCollection();
                    for (Covariate cov : this.requestedCovariates) {
                        cov.initialize(RAC);
                    }
                    this.dataManager = new RecalDataManager(true, this.requestedCovariates.size());
                }
                this.addCSVData(RECAL_FILE, line);
            }
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotReadInputFile(RECAL_FILE, "Can not find input file", e);
        }
        catch (NumberFormatException e) {
            throw new UserException.MalformedFile(RECAL_FILE, "Error parsing recalibration data at line " + lineNumber + ". Perhaps your table was generated by an older version of CovariateCounterWalker.");
        }
        if (!sawEOF) {
            String errorMessage = "No EOF marker was present in the recal covariates table; this could mean that the file is corrupted or was generated with an old version of the CountCovariates tool.";
            throw new UserException.MalformedFile(RECAL_FILE, "No EOF marker was present in the recal covariates table; this could mean that the file is corrupted or was generated with an old version of the CountCovariates tool.");
        }
        if (this.dataManager == null) {
            throw new UserException.MalformedFile(RECAL_FILE, "Can't initialize the data manager. Perhaps the recal csv file contains no data?");
        }
        this.dataManager.generateEmpiricalQualities(1, 65);
    }

    private void addCSVData(File file, String line) {
        int iii;
        String[] vals = line.split(",");
        if (vals.length != this.requestedCovariates.size() + 4) {
            throw new UserException.MalformedFile(file, "Malformed input recalibration file. Found data line with too many fields: " + line + " --Perhaps the read group string contains a comma and isn't being parsed correctly.");
        }
        Object[] key = new Object[this.requestedCovariates.size()];
        for (iii = 0; iii < this.requestedCovariates.size(); ++iii) {
            Covariate cov = this.requestedCovariates.get(iii);
            key[iii] = cov.getValue(vals[iii]);
        }
        String modelString = vals[iii++];
        RecalDataManager.BaseRecalibrationType errorModel = CovariateKeySet.getErrorModelFromString(modelString);
        RecalDatum datum = new RecalDatum(Long.parseLong(vals[iii]), Long.parseLong(vals[iii + 1]), Double.parseDouble(vals[1]), 0.0);
        this.dataManager.addToAllTables(key, datum, 6, errorModel);
    }

    public void recalibrateRead(GATKSAMRecord read) {
        RecalDataManager.computeCovariates(read, this.requestedCovariates);
        CovariateKeySet covariateKeySet = RecalDataManager.getAllCovariateValuesFor(read);
        for (RecalDataManager.BaseRecalibrationType errorModel : RecalDataManager.BaseRecalibrationType.values()) {
            byte[] originalQuals = read.getBaseQualities(errorModel);
            byte[] recalQuals = (byte[])originalQuals.clone();
            for (int offset = 0; offset < read.getReadLength(); ++offset) {
                byte qualityScore;
                Object[] fullCovariateKeyWithErrorMode = covariateKeySet.getKeySet(offset, errorModel);
                Object[] fullCovariateKey = Arrays.copyOfRange(fullCovariateKeyWithErrorMode, 0, fullCovariateKeyWithErrorMode.length - 1);
                recalQuals[offset] = qualityScore = this.performSequentialQualityCalculation(errorModel, fullCovariateKey);
            }
            this.preserveQScores(originalQuals, recalQuals);
            read.setBaseQualities(recalQuals, errorModel);
        }
    }

    private byte performSequentialQualityCalculation(RecalDataManager.BaseRecalibrationType errorModel, Object ... key) {
        byte qualFromRead = (byte)Integer.parseInt(key[1].toString());
        Object[] readGroupCollapsedKey = new Object[1];
        Object[] qualityScoreCollapsedKey = new Object[2];
        Object[] covariateCollapsedKey = new Object[3];
        readGroupCollapsedKey[0] = key[0];
        RecalDatum globalRecalDatum = (RecalDatum)this.dataManager.getCollapsedTable(0, errorModel).get(readGroupCollapsedKey);
        double globalDeltaQ = 0.0;
        if (globalRecalDatum != null) {
            double globalDeltaQEmpirical = globalRecalDatum.getEmpiricalQuality();
            double aggregrateQReported = globalRecalDatum.getEstimatedQReported();
            globalDeltaQ = globalDeltaQEmpirical - aggregrateQReported;
        }
        qualityScoreCollapsedKey[0] = key[0];
        qualityScoreCollapsedKey[1] = key[1];
        RecalDatum qReportedRecalDatum = (RecalDatum)this.dataManager.getCollapsedTable(1, errorModel).get(qualityScoreCollapsedKey);
        double deltaQReported = 0.0;
        if (qReportedRecalDatum != null) {
            double deltaQReportedEmpirical = qReportedRecalDatum.getEmpiricalQuality();
            deltaQReported = deltaQReportedEmpirical - (double)qualFromRead - globalDeltaQ;
        }
        double deltaQCovariates = 0.0;
        covariateCollapsedKey[0] = key[0];
        covariateCollapsedKey[1] = key[1];
        for (int iii = 2; iii < key.length; ++iii) {
            covariateCollapsedKey[2] = key[iii];
            RecalDatum covariateRecalDatum = (RecalDatum)this.dataManager.getCollapsedTable(iii, errorModel).get(covariateCollapsedKey);
            if (covariateRecalDatum == null) continue;
            double deltaQCovariateEmpirical = covariateRecalDatum.getEmpiricalQuality();
            deltaQCovariates += deltaQCovariateEmpirical - (double)qualFromRead - (globalDeltaQ + deltaQReported);
        }
        double newQuality = (double)qualFromRead + globalDeltaQ + deltaQReported + deltaQCovariates;
        return QualityUtils.boundQual((int)Math.round(newQuality), (byte)65);
    }

    private void preserveQScores(byte[] originalQuals, byte[] recalQuals) {
        for (int iii = 0; iii < recalQuals.length; ++iii) {
            if (originalQuals[iii] >= 6) continue;
            recalQuals[iii] = originalQuals[iii];
        }
    }
}

