/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.reflections.Configuration;
import org.reflections.adapters.JavassistAdapter;
import org.reflections.adapters.MetadataAdapter;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.serializers.Serializer;
import org.reflections.serializers.XmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationBuilder
implements Configuration {
    private Set<Scanner> scanners = Sets.newHashSet(new SubTypesScanner(), new TypeAnnotationsScanner());
    private Set<URL> urls;
    private MetadataAdapter metadataAdapter = new JavassistAdapter();
    private Predicate<String> inputsFilter = Predicates.alwaysTrue();
    private Serializer serializer = new XmlSerializer();
    private Supplier<ExecutorService> executorServiceSupplier = new Supplier<ExecutorService>(){

        @Override
        public ExecutorService get() {
            return Executors.newSingleThreadExecutor();
        }
    };

    @Override
    public Set<Scanner> getScanners() {
        return this.scanners;
    }

    public ConfigurationBuilder setScanners(Scanner ... scanners) {
        this.scanners = ImmutableSet.of(scanners);
        return this;
    }

    @Override
    public Set<URL> getUrls() {
        return this.urls;
    }

    public ConfigurationBuilder setUrls(Collection<URL> urls) {
        this.urls = ImmutableSet.copyOf(urls);
        return this;
    }

    public ConfigurationBuilder setUrls(URL ... urls) {
        this.urls = ImmutableSet.of(urls);
        return this;
    }

    @Override
    public MetadataAdapter getMetadataAdapter() {
        return this.metadataAdapter;
    }

    public ConfigurationBuilder setMetadataAdapter(MetadataAdapter metadataAdapter) {
        this.metadataAdapter = metadataAdapter;
        return this;
    }

    @Override
    public boolean acceptsInput(String inputFqn) {
        return this.inputsFilter.apply(inputFqn);
    }

    public ConfigurationBuilder filterInputsBy(Predicate<String> inputsFilter) {
        this.inputsFilter = inputsFilter;
        return this;
    }

    @Override
    public Supplier<ExecutorService> getExecutorServiceSupplier() {
        return this.executorServiceSupplier;
    }

    public ConfigurationBuilder setExecutorServiceSupplier(Supplier<ExecutorService> executorServiceSupplier) {
        this.executorServiceSupplier = executorServiceSupplier;
        return this;
    }

    public ConfigurationBuilder useParallelExecutor() {
        return this.useParallelExecutor(Runtime.getRuntime().availableProcessors());
    }

    public ConfigurationBuilder useParallelExecutor(final int availableProcessors) {
        this.setExecutorServiceSupplier(new Supplier<ExecutorService>(){

            @Override
            public ExecutorService get() {
                return Executors.newFixedThreadPool(availableProcessors);
            }
        });
        return this;
    }

    @Override
    public Serializer getSerializer() {
        return this.serializer;
    }

    public ConfigurationBuilder setSerializer(Serializer serializer) {
        this.serializer = serializer;
        return this;
    }
}

