/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.simpleframework.xml.core.GetPart;
import org.simpleframework.xml.core.MethodException;
import org.simpleframework.xml.core.MethodName;
import org.simpleframework.xml.core.MethodPart;
import org.simpleframework.xml.core.MethodType;
import org.simpleframework.xml.core.SetPart;

final class MethodPartFactory {
    MethodPartFactory() {
    }

    public static MethodPart getInstance(Method method, Annotation label) throws Exception {
        MethodName name = MethodPartFactory.getName(method, label);
        MethodType type = name.getType();
        if (type == MethodType.SET) {
            return new SetPart(name, label);
        }
        return new GetPart(name, label);
    }

    private static MethodName getName(Method method, Annotation label) throws Exception {
        MethodType type = MethodPartFactory.getPrefixType(method);
        if (type == MethodType.GET) {
            return MethodPartFactory.getRead(method, type);
        }
        if (type == MethodType.IS) {
            return MethodPartFactory.getRead(method, type);
        }
        if (type == MethodType.SET) {
            return MethodPartFactory.getWrite(method, type);
        }
        throw new MethodException("Annotation %s must mark a set or get method", label);
    }

    private static MethodType getPrefixType(Method method) {
        String name = method.getName();
        if (name.startsWith("get")) {
            return MethodType.GET;
        }
        if (name.startsWith("is")) {
            return MethodType.IS;
        }
        if (name.startsWith("set")) {
            return MethodType.SET;
        }
        return null;
    }

    private static MethodName getRead(Method method, MethodType type) throws Exception {
        Class<?>[] list = method.getParameterTypes();
        String real = method.getName();
        if (list.length != 0) {
            throw new MethodException("Get method %s in %s contains parameters", new Object[]{real, type});
        }
        String name = MethodPartFactory.getTypeName(real, type);
        return new MethodName(method, type, name);
    }

    private static MethodName getWrite(Method method, MethodType type) throws Exception {
        Class<?>[] list = method.getParameterTypes();
        String real = method.getName();
        if (list.length != 1) {
            throw new MethodException("Set method %s has invalid signature in %s", new Object[]{real, type});
        }
        String name = MethodPartFactory.getTypeName(real, type);
        return new MethodName(method, type, name);
    }

    private static String getTypeName(String name, MethodType type) {
        int prefix = type.getPrefix();
        int size = name.length();
        if (size > prefix) {
            name = name.substring(prefix, size);
        }
        return Introspector.decapitalize(name);
    }
}

