/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.Collection;
import net.sf.picard.PicardException;
import net.sf.samtools.util.CoordMath;

public class Interval
implements Comparable<Interval>,
Cloneable {
    private final String sequence;
    private final int start;
    private final int end;
    private final boolean negativeStrand;
    private final String name;

    public Interval(String sequence, int start, int end) {
        this(sequence, start, end, false, null);
    }

    public Interval(String sequence, int start, int end, boolean negative, String name) {
        this.sequence = sequence;
        this.start = start;
        this.end = end;
        this.negativeStrand = negative;
        this.name = name;
        if (this.end < this.start - 1) {
            throw new IllegalArgumentException("start must be less than or equal to end!");
        }
    }

    public String getSequence() {
        return this.sequence;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean isNegativeStrand() {
        return this.negativeStrand;
    }

    public boolean isPositiveStrand() {
        return !this.negativeStrand;
    }

    public String getName() {
        return this.name;
    }

    public boolean intersects(Interval other) {
        return this.getSequence().equals(other.getSequence()) && CoordMath.overlaps(this.start, this.end, other.start, other.end);
    }

    public int getIntersectionLength(Interval other) {
        if (this.intersects(other)) {
            return CoordMath.getOverlap(this.getStart(), this.getEnd(), other.getStart(), other.getEnd());
        }
        return 0;
    }

    public Interval intersect(Interval that) {
        if (!this.intersects(that)) {
            throw new IllegalArgumentException(that + " does not intersect " + this);
        }
        return new Interval(this.sequence, Math.max(this.start, that.start), Math.min(this.end, that.end), this.negativeStrand, this.name + " intersection " + that.name);
    }

    public boolean abuts(Interval other) {
        return this.getSequence().equals(other.getSequence()) && (this.start == other.end + 1 || other.start == this.end + 1);
    }

    public int length() {
        return this.end - this.start + 1;
    }

    public Interval pad(int left, int right) {
        return new Interval(this.sequence, this.start - left, this.end + right, this.negativeStrand, this.name);
    }

    public static long countBases(Collection<Interval> intervals) {
        long total = 0L;
        for (Interval i : intervals) {
            total += (long)i.length();
        }
        return total;
    }

    @Override
    public int compareTo(Interval that) {
        if (that == null) {
            return -1;
        }
        int result = this.sequence.compareTo(that.sequence);
        if (result == 0) {
            result = this.start == that.start ? this.end - that.end : this.start - that.start;
        }
        return result;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Interval)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        Interval that = (Interval)other;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        int result = this.sequence.hashCode();
        result = 31 * result + this.start;
        result = 31 * result + this.end;
        return result;
    }

    public String toString() {
        return this.getSequence() + ":" + this.start + "-" + this.end;
    }

    public Interval clone() {
        try {
            return (Interval)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new PicardException("That's unpossible", cnse);
        }
    }
}

