/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment.bwa.java;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import org.broadinstitute.sting.alignment.bwa.java.AlignmentState;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class AlignmentMatchSequence
implements Cloneable {
    private Deque<AlignmentMatchSequenceEntry> entries = new ArrayDeque<AlignmentMatchSequenceEntry>();

    public AlignmentMatchSequence clone() {
        AlignmentMatchSequence copy = null;
        try {
            copy = (AlignmentMatchSequence)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new ReviewedStingException("Unable to clone AlignmentMatchSequence.");
        }
        copy.entries = new ArrayDeque<AlignmentMatchSequenceEntry>();
        for (AlignmentMatchSequenceEntry entry : this.entries) {
            copy.entries.add(entry.clone());
        }
        return copy;
    }

    public Cigar convertToCigar(boolean negativeStrand) {
        Iterator<AlignmentMatchSequenceEntry> iterator;
        Cigar cigar = new Cigar();
        Iterator<AlignmentMatchSequenceEntry> iterator2 = iterator = negativeStrand ? this.entries.descendingIterator() : this.entries.iterator();
        while (iterator.hasNext()) {
            CigarOperator operator;
            AlignmentMatchSequenceEntry entry = iterator.next();
            switch (entry.getAlignmentState()) {
                case MATCH_MISMATCH: {
                    operator = CigarOperator.MATCH_OR_MISMATCH;
                    break;
                }
                case INSERTION: {
                    operator = CigarOperator.INSERTION;
                    break;
                }
                case DELETION: {
                    operator = CigarOperator.DELETION;
                    break;
                }
                default: {
                    throw new ReviewedStingException("convertToCigar: cannot process state: " + (Object)((Object)entry.getAlignmentState()));
                }
            }
            cigar.add(new CigarElement(entry.count, operator));
        }
        return cigar;
    }

    public void addNext(AlignmentState state) {
        AlignmentMatchSequenceEntry last = this.entries.peekLast();
        if (last != null && last.alignmentState == state) {
            last.increment();
        } else {
            this.entries.add(new AlignmentMatchSequenceEntry(state));
        }
    }

    public AlignmentState getCurrentState() {
        if (this.entries.size() == 0) {
            return AlignmentState.MATCH_MISMATCH;
        }
        return this.entries.peekLast().getAlignmentState();
    }

    public int getNumberOfBasesMatchingState(AlignmentState state) {
        int matches = 0;
        for (AlignmentMatchSequenceEntry entry : this.entries) {
            if (entry.getAlignmentState() != state) continue;
            matches += entry.count;
        }
        return matches;
    }

    private class AlignmentMatchSequenceEntry
    implements Cloneable {
        private final AlignmentState alignmentState;
        private int count;

        AlignmentMatchSequenceEntry(AlignmentState alignmentState) {
            this.alignmentState = alignmentState;
            this.count = 1;
        }

        public AlignmentMatchSequenceEntry clone() {
            try {
                return (AlignmentMatchSequenceEntry)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new ReviewedStingException("Unable to clone AlignmentMatchSequenceEntry.");
            }
        }

        AlignmentState getAlignmentState() {
            return this.alignmentState;
        }

        void increment() {
            ++this.count;
        }
    }
}

