/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment.bwa.java;

import net.sf.samtools.Cigar;
import org.broadinstitute.sting.alignment.Alignment;
import org.broadinstitute.sting.alignment.bwa.java.AlignmentMatchSequence;
import org.broadinstitute.sting.alignment.bwa.java.AlignmentState;
import org.broadinstitute.sting.alignment.bwa.java.BWAJavaAligner;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class BWAAlignment
extends Alignment
implements Cloneable {
    private static long numCreated;
    private long creationNumber;
    protected BWAJavaAligner aligner;
    private AlignmentMatchSequence alignmentMatchSequence = new AlignmentMatchSequence();
    protected int position;
    private int mismatches;
    private int gapOpens;
    private int gapExtensions;
    protected long loBound;
    protected long hiBound;
    private int score;

    protected void setAlignmentStart(long position) {
        this.alignmentStart = position;
    }

    protected void setNegativeStrand(boolean negativeStrand) {
        this.negativeStrand = negativeStrand;
    }

    @Override
    public Cigar getCigar() {
        return this.alignmentMatchSequence.convertToCigar(this.isNegativeStrand());
    }

    public AlignmentState getCurrentState() {
        return this.alignmentMatchSequence.getCurrentState();
    }

    public void addState(AlignmentState state) {
        this.alignmentMatchSequence.addNext(state);
    }

    public int getScore() {
        return this.score;
    }

    public int getMismatches() {
        return this.mismatches;
    }

    public int getGapOpens() {
        return this.gapOpens;
    }

    public int getGapExtensions() {
        return this.gapExtensions;
    }

    public void incrementMismatches() {
        ++this.mismatches;
        this.updateScore();
    }

    public void incrementGapOpens() {
        ++this.gapOpens;
        this.updateScore();
    }

    public void incrementGapExtensions() {
        ++this.gapExtensions;
        this.updateScore();
    }

    private void updateScore() {
        this.score = this.mismatches * this.aligner.MISMATCH_PENALTY + this.gapOpens * this.aligner.GAP_OPEN_PENALTY + this.gapExtensions * this.aligner.GAP_EXTENSION_PENALTY;
    }

    public BWAAlignment(BWAJavaAligner aligner) {
        this.aligner = aligner;
        this.creationNumber = numCreated++;
    }

    public BWAAlignment clone() {
        BWAAlignment newAlignment = null;
        try {
            newAlignment = (BWAAlignment)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new ReviewedStingException("Unable to clone BWAAlignment.");
        }
        newAlignment.creationNumber = numCreated++;
        newAlignment.alignmentMatchSequence = this.alignmentMatchSequence.clone();
        return newAlignment;
    }

    public int getNumberOfBasesMatchingState(AlignmentState state) {
        return this.alignmentMatchSequence.getNumberOfBasesMatchingState(state);
    }

    public int compareTo(Alignment rhs) {
        BWAAlignment other = (BWAAlignment)rhs;
        if (this.score != other.score) {
            return this.score > other.score ? 1 : -1;
        }
        if (this.creationNumber != other.creationNumber) {
            return this.creationNumber > other.creationNumber ? -1 : 1;
        }
        return 0;
    }

    public String toString() {
        return String.format("position: %d, strand: %b, state: %s, mismatches: %d, gap opens: %d, gap extensions: %d, loBound: %d, hiBound: %d, score: %d, creationNumber: %d", new Object[]{this.position, this.negativeStrand, this.alignmentMatchSequence.getCurrentState(), this.mismatches, this.gapOpens, this.gapExtensions, this.loBound, this.hiBound, this.getScore(), this.creationNumber});
    }
}

