/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.refdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.samtools.util.SequenceUtil;
import org.broad.tribble.Feature;
import org.broad.tribble.annotation.Strand;
import org.broad.tribble.dbsnp.OldDbSNPFeature;
import org.broad.tribble.gelitext.GeliTextFeature;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.classloader.PluginManager;
import org.broadinstitute.sting.utils.codecs.hapmap.RawHapMapFeature;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;

public class VariantContextAdaptors {
    private static Map<Class<? extends Feature>, VCAdaptor> adaptors = new HashMap<Class<? extends Feature>, VCAdaptor>();

    public static boolean canBeConvertedToVariantContext(Object variantContainingObject) {
        return adaptors.containsKey(variantContainingObject.getClass());
    }

    public static VariantContext toVariantContext(String name, Object variantContainingObject, ReferenceContext ref) {
        if (!adaptors.containsKey(variantContainingObject.getClass())) {
            return null;
        }
        return adaptors.get(variantContainingObject.getClass()).convert(name, variantContainingObject, ref);
    }

    static {
        PluginManager<VCAdaptor> vcAdaptorManager = new PluginManager<VCAdaptor>(VCAdaptor.class);
        List<VCAdaptor> adaptorInstances = vcAdaptorManager.createAllTypes();
        for (VCAdaptor adaptor : adaptorInstances) {
            adaptors.put(adaptor.getAdaptableFeatureType(), adaptor);
        }
    }

    private static class HapMapAdaptor
    implements VCAdaptor {
        private HapMapAdaptor() {
        }

        @Override
        public Class<? extends Feature> getAdaptableFeatureType() {
            return RawHapMapFeature.class;
        }

        @Override
        public VariantContext convert(String name, Object input, ReferenceContext ref) {
            if (ref == null) {
                throw new UnsupportedOperationException("Conversion from HapMap to VariantContext requires a reference context");
            }
            RawHapMapFeature hapmap = (RawHapMapFeature)input;
            int index = hapmap.getStart() - ref.getWindow().getStart();
            if (index < 0) {
                return null;
            }
            Byte refBaseForIndel = new Byte(ref.getBases()[index]);
            HashSet<Allele> alleles = new HashSet<Allele>();
            Allele refSNPAllele = Allele.create(ref.getBase(), true);
            int deletionLength = -1;
            Map<String, Allele> alleleMap = hapmap.getActualAlleles();
            if (alleleMap != null) {
                alleles.addAll(alleleMap.values());
                Allele deletionAllele = alleleMap.get("I");
                if (deletionAllele != null && deletionAllele.isReference()) {
                    deletionLength = deletionAllele.length();
                }
            } else {
                alleles.add(refSNPAllele);
            }
            String[] samples = hapmap.getSampleIDs();
            String[] genotypeStrings = hapmap.getGenotypes();
            GenotypesContext genotypes = GenotypesContext.create(samples.length);
            for (int i = 0; i < samples.length; ++i) {
                if (genotypeStrings[i].contains("N")) continue;
                String a1 = genotypeStrings[i].substring(0, 1);
                String a2 = genotypeStrings[i].substring(1);
                ArrayList<Allele> myAlleles = new ArrayList<Allele>(2);
                if (alleleMap != null) {
                    myAlleles.add(alleleMap.get(a1));
                    myAlleles.add(alleleMap.get(a2));
                } else {
                    if (genotypeStrings[i].contains("I") || genotypeStrings[i].contains("D")) continue;
                    Allele allele1 = Allele.create(a1, refSNPAllele.basesMatch(a1));
                    Allele allele2 = Allele.create(a2, refSNPAllele.basesMatch(a2));
                    myAlleles.add(allele1);
                    myAlleles.add(allele2);
                    alleles.add(allele1);
                    alleles.add(allele2);
                }
                Genotype g = new Genotype(samples[i], myAlleles);
                genotypes.add(g);
            }
            long end = hapmap.getEnd();
            if (deletionLength > 0) {
                end += (long)deletionLength;
            }
            VariantContext vc = new VariantContextBuilder(name, hapmap.getChr(), hapmap.getStart(), end, alleles).id(hapmap.getName()).genotypes(genotypes).referenceBaseForIndel(refBaseForIndel).make();
            return vc;
        }
    }

    private static class GeliTextAdaptor
    implements VCAdaptor {
        private GeliTextAdaptor() {
        }

        @Override
        public Class<? extends Feature> getAdaptableFeatureType() {
            return GeliTextFeature.class;
        }

        @Override
        public VariantContext convert(String name, Object input, ReferenceContext ref) {
            GeliTextFeature geli = (GeliTextFeature)input;
            if (!Allele.acceptableAlleleBases(String.valueOf(geli.getRefBase()))) {
                return null;
            }
            Allele refAllele = Allele.create(String.valueOf(geli.getRefBase()), true);
            if (geli.getGenotype().isHet() || !geli.getGenotype().containsBase(geli.getRefBase())) {
                ArrayList<Allele> alleles = new ArrayList<Allele>();
                ArrayList<Allele> genotypeAlleles = new ArrayList<Allele>();
                for (char alt : geli.getGenotype().toString().toCharArray()) {
                    if (!Allele.acceptableAlleleBases(String.valueOf(alt))) {
                        return null;
                    }
                    Allele allele = Allele.create(String.valueOf(alt), false);
                    if (!alleles.contains(allele) && !refAllele.basesMatch(allele.getBases())) {
                        alleles.add(allele);
                    }
                    if (!refAllele.basesMatch(allele.getBases())) {
                        genotypeAlleles.add(allele);
                        continue;
                    }
                    genotypeAlleles.add(refAllele);
                }
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                ArrayList<Genotype> genotypes = new ArrayList<Genotype>();
                Genotype call = new Genotype(name, genotypeAlleles);
                genotypes.add(call);
                alleles.add(refAllele);
                GenomeLoc loc = ref.getGenomeLocParser().createGenomeLoc(geli.getChr(), geli.getStart());
                return new VariantContextBuilder(name, loc.getContig(), loc.getStart(), loc.getStop(), alleles).genotypes(genotypes).log10PError(-1.0 * geli.getLODBestToReference()).attributes(attributes).make();
            }
            return null;
        }
    }

    private static class DBSnpAdaptor
    implements VCAdaptor {
        private DBSnpAdaptor() {
        }

        private static boolean isSNP(OldDbSNPFeature feature) {
            return feature.getVariantType().contains("single") && feature.getLocationType().contains("exact");
        }

        private static boolean isMNP(OldDbSNPFeature feature) {
            return feature.getVariantType().contains("mnp") && feature.getLocationType().contains("range");
        }

        private static boolean isInsertion(OldDbSNPFeature feature) {
            return feature.getVariantType().contains("insertion");
        }

        private static boolean isDeletion(OldDbSNPFeature feature) {
            return feature.getVariantType().contains("deletion");
        }

        private static boolean isIndel(OldDbSNPFeature feature) {
            return DBSnpAdaptor.isInsertion(feature) || DBSnpAdaptor.isDeletion(feature) || DBSnpAdaptor.isComplexIndel(feature);
        }

        public static boolean isComplexIndel(OldDbSNPFeature feature) {
            return feature.getVariantType().contains("in-del");
        }

        public static List<String> getAlternateAlleleList(OldDbSNPFeature feature) {
            ArrayList<String> ret = new ArrayList<String>();
            for (String allele : DBSnpAdaptor.getAlleleList(feature)) {
                if (allele.equals(String.valueOf(feature.getNCBIRefBase()))) continue;
                ret.add(allele);
            }
            return ret;
        }

        public static List<String> getAlleleList(OldDbSNPFeature feature) {
            List<Object> alleleList = new ArrayList();
            if (feature.getStrand() == Strand.POSITIVE) {
                alleleList = Arrays.asList(feature.getObserved());
            } else {
                for (String str : feature.getObserved()) {
                    alleleList.add(SequenceUtil.reverseComplement(str));
                }
            }
            if (alleleList.size() > 0 && alleleList.contains(feature.getNCBIRefBase()) && !((String)alleleList.get(0)).equals(feature.getNCBIRefBase())) {
                Collections.swap(alleleList, alleleList.indexOf(feature.getNCBIRefBase()), 0);
            }
            return alleleList;
        }

        @Override
        public Class<? extends Feature> getAdaptableFeatureType() {
            return OldDbSNPFeature.class;
        }

        @Override
        public VariantContext convert(String name, Object input, ReferenceContext ref) {
            OldDbSNPFeature dbsnp = (OldDbSNPFeature)input;
            if (!Allele.acceptableAlleleBases(dbsnp.getNCBIRefBase())) {
                return null;
            }
            Allele refAllele = Allele.create(dbsnp.getNCBIRefBase(), true);
            if (DBSnpAdaptor.isSNP(dbsnp) || DBSnpAdaptor.isIndel(dbsnp) || DBSnpAdaptor.isMNP(dbsnp) || dbsnp.getVariantType().contains("mixed")) {
                ArrayList<Allele> alleles = new ArrayList<Allele>();
                alleles.add(refAllele);
                boolean sawNullAllele = refAllele.isNull();
                for (String alt : DBSnpAdaptor.getAlternateAlleleList(dbsnp)) {
                    if (!Allele.acceptableAlleleBases(alt)) {
                        return null;
                    }
                    Allele altAllele = Allele.create(alt, false);
                    alleles.add(altAllele);
                    if (!altAllele.isNull()) continue;
                    sawNullAllele = true;
                }
                HashMap attributes = new HashMap();
                int index = dbsnp.getStart() - ref.getWindow().getStart() - 1;
                if (index < 0) {
                    return null;
                }
                Byte refBaseForIndel = new Byte(ref.getBases()[index]);
                VariantContextBuilder builder = new VariantContextBuilder();
                builder.source(name).id(dbsnp.getRsID());
                builder.loc(dbsnp.getChr(), dbsnp.getStart() - (sawNullAllele ? 1 : 0), dbsnp.getEnd() - (refAllele.isNull() ? 1 : 0));
                builder.alleles(alleles);
                builder.referenceBaseForIndel(refBaseForIndel);
                return builder.make();
            }
            return null;
        }
    }

    private static class VariantContextAdaptor
    implements VCAdaptor {
        private VariantContextAdaptor() {
        }

        @Override
        public Class<? extends Feature> getAdaptableFeatureType() {
            return VariantContext.class;
        }

        @Override
        public VariantContext convert(String name, Object input, ReferenceContext ref) {
            return (VariantContext)input;
        }
    }

    public static interface VCAdaptor {
        public Class<? extends Feature> getAdaptableFeatureType();

        public VariantContext convert(String var1, Object var2, ReferenceContext var3);
    }
}

