/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.traversals;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.WalkerManager;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.datasources.providers.AllLocusView;
import org.broadinstitute.sting.gatk.datasources.providers.CoveredLocusView;
import org.broadinstitute.sting.gatk.datasources.providers.LocusReferenceView;
import org.broadinstitute.sting.gatk.datasources.providers.LocusShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.providers.LocusView;
import org.broadinstitute.sting.gatk.datasources.providers.ManagingReferenceOrderedView;
import org.broadinstitute.sting.gatk.datasources.providers.ReferenceOrderedView;
import org.broadinstitute.sting.gatk.datasources.providers.RodLocusView;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.traversals.TraversalEngine;
import org.broadinstitute.sting.gatk.walkers.ActiveRegionExtension;
import org.broadinstitute.sting.gatk.walkers.ActiveRegionWalker;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocSortedSet;
import org.broadinstitute.sting.utils.activeregion.ActiveRegion;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class TraverseActiveRegions<M, T>
extends TraversalEngine<M, T, ActiveRegionWalker<M, T>, LocusShardDataProvider> {
    protected static Logger logger = Logger.getLogger(TraversalEngine.class);
    private final Queue<ActiveRegion> workQueue = new LinkedList<ActiveRegion>();
    private final LinkedHashSet<GATKSAMRecord> myReads = new LinkedHashSet();

    @Override
    protected String getTraversalType() {
        return "active regions";
    }

    @Override
    public T traverse(ActiveRegionWalker<M, T> walker, LocusShardDataProvider dataProvider, T sum) {
        logger.debug(String.format("TraverseActiveRegion.traverse: Shard is %s", dataProvider));
        LocusView locusView = this.getLocusView(walker, dataProvider);
        GenomeLocSortedSet initialIntervals = this.engine.getIntervals();
        LocusReferenceView referenceView = new LocusReferenceView(walker, dataProvider);
        int activeRegionExtension = walker.getClass().getAnnotation(ActiveRegionExtension.class).extension();
        if (locusView.hasNext()) {
            int minStart = Integer.MAX_VALUE;
            ArrayList<Double> isActiveList = new ArrayList<Double>();
            GenomeLoc firstIsActiveStart = null;
            ReferenceOrderedView referenceOrderedDataView = null;
            referenceOrderedDataView = WalkerManager.getWalkerDataSource(walker) != DataSource.REFERENCE_ORDERED_DATA ? new ManagingReferenceOrderedView(dataProvider) : (RodLocusView)locusView;
            GenomeLoc prevLoc = null;
            while (locusView.hasNext()) {
                GATKSAMRecord read;
                double isActiveProb;
                AlignmentContext locus = locusView.next();
                GenomeLoc location = locus.getLocation();
                if (prevLoc != null) {
                    for (int iii = prevLoc.getStart() + 1; iii < location.getStart(); ++iii) {
                        GenomeLoc fakeLoc = this.engine.getGenomeLocParser().createGenomeLoc(prevLoc.getContig(), iii, iii);
                        if (initialIntervals != null && !initialIntervals.overlaps(fakeLoc)) continue;
                        isActiveProb = walker.presetActiveRegions == null ? 0.0 : (walker.presetActiveRegions.overlaps(fakeLoc) ? 1.0 : 0.0);
                        isActiveList.add(isActiveProb);
                        if (firstIsActiveStart != null) continue;
                        firstIsActiveStart = fakeLoc;
                    }
                }
                dataProvider.getShard().getReadMetrics().incrementNumIterations();
                ReferenceContext refContext = referenceView.getReferenceContext(location);
                RefMetaDataTracker tracker = referenceOrderedDataView.getReferenceOrderedDataAtLocus(locus.getLocation(), refContext);
                if (initialIntervals == null || initialIntervals.overlaps(location)) {
                    isActiveProb = walker.presetActiveRegions == null ? walker.isActive(tracker, refContext, locus) : (walker.presetActiveRegions.overlaps(location) ? 1.0 : 0.0);
                    isActiveList.add(isActiveProb);
                    if (firstIsActiveStart == null) {
                        firstIsActiveStart = location;
                    }
                }
                for (PileupElement p : locus.getBasePileup()) {
                    read = p.getRead();
                    if (this.myReads.contains(read)) continue;
                    this.myReads.add(read);
                }
                if (!locusView.hasNext()) {
                    for (PileupElement p : locus.getBasePileup()) {
                        read = p.getRead();
                        if (!this.myReads.contains(read)) {
                            this.myReads.add(read);
                        }
                        if (read.getAlignmentStart() >= minStart) continue;
                        minStart = read.getAlignmentStart();
                    }
                }
                prevLoc = location;
                this.printProgress(dataProvider.getShard(), locus.getLocation());
            }
            ArrayList<ActiveRegion> activeRegions = this.integrateActiveList(isActiveList, firstIsActiveStart, activeRegionExtension, walker.presetActiveRegions != null);
            logger.debug("Integrated " + isActiveList.size() + " isActive calls into " + activeRegions.size() + " regions.");
            if (walker.activeRegionOutStream == null) {
                this.workQueue.addAll(activeRegions);
            } else {
                for (ActiveRegion activeRegion : activeRegions) {
                    if (!activeRegion.isActive) continue;
                    walker.activeRegionOutStream.println(activeRegion.getLocation());
                }
            }
            while (!(this.workQueue.peek() == null || this.workQueue.peek().getExtendedLoc().getStop() >= minStart && this.workQueue.peek().getExtendedLoc().getContig().equals(dataProvider.getLocus().getContig()))) {
                ActiveRegion activeRegion = this.workQueue.remove();
                sum = this.processActiveRegion(activeRegion, this.myReads, this.workQueue, sum, walker);
            }
        }
        return sum;
    }

    public T endTraversal(Walker<M, T> walker, T sum) {
        while (this.workQueue.peek() != null) {
            ActiveRegion activeRegion = this.workQueue.remove();
            sum = this.processActiveRegion(activeRegion, this.myReads, this.workQueue, sum, (ActiveRegionWalker)walker);
        }
        return sum;
    }

    private T processActiveRegion(ActiveRegion activeRegion, LinkedHashSet<GATKSAMRecord> reads, Queue<ActiveRegion> workQueue, T sum, ActiveRegionWalker<M, T> walker) {
        ArrayList<GATKSAMRecord> placedReads = new ArrayList<GATKSAMRecord>();
        for (GATKSAMRecord read : reads) {
            GenomeLoc readLoc = this.engine.getGenomeLocParser().createGenomeLoc(read);
            if (activeRegion.getLocation().overlapsP(readLoc)) {
                long maxOverlap = activeRegion.getLocation().sizeOfOverlap(readLoc);
                ActiveRegion bestRegion = activeRegion;
                for (ActiveRegion otherRegionToTest : workQueue) {
                    if (otherRegionToTest.getLocation().sizeOfOverlap(readLoc) < maxOverlap) continue;
                    maxOverlap = otherRegionToTest.getLocation().sizeOfOverlap(readLoc);
                    bestRegion = otherRegionToTest;
                }
                bestRegion.add(read);
                if (walker.wantsNonPrimaryReads()) {
                    if (!bestRegion.equals(activeRegion)) {
                        activeRegion.add(read);
                    }
                    for (ActiveRegion otherRegionToTest : workQueue) {
                        if (bestRegion.equals(otherRegionToTest) || !otherRegionToTest.getExtendedLoc().overlapsP(readLoc)) continue;
                        otherRegionToTest.add(read);
                    }
                }
                placedReads.add(read);
                continue;
            }
            if (!activeRegion.getExtendedLoc().overlapsP(readLoc) || !walker.wantsNonPrimaryReads()) continue;
            activeRegion.add(read);
        }
        reads.removeAll(placedReads);
        logger.debug(">> Map call with " + activeRegion.getReads().size() + " " + (activeRegion.isActive ? "active" : "inactive") + " reads @ " + activeRegion.getLocation() + " with full extent: " + activeRegion.getReferenceLoc());
        M x = walker.map(activeRegion, null);
        return walker.reduce(x, sum);
    }

    private LocusView getLocusView(Walker<M, T> walker, LocusShardDataProvider dataProvider) {
        DataSource dataSource = WalkerManager.getWalkerDataSource(walker);
        if (dataSource == DataSource.READS) {
            return new CoveredLocusView(dataProvider);
        }
        if (dataSource == DataSource.REFERENCE) {
            return new AllLocusView(dataProvider);
        }
        if (dataSource == DataSource.REFERENCE_ORDERED_DATA) {
            return new RodLocusView(dataProvider);
        }
        throw new UnsupportedOperationException("Unsupported traversal type: " + (Object)((Object)dataSource));
    }

    private ArrayList<ActiveRegion> integrateActiveList(ArrayList<Double> activeList, GenomeLoc firstIsActiveStart, int activeRegionExtension, boolean presetRegions) {
        double ACTIVE_PROB_THRESHOLD = 0.2;
        ArrayList<ActiveRegion> returnList = new ArrayList<ActiveRegion>();
        if (activeList.size() == 0) {
            return returnList;
        }
        if (activeList.size() == 1) {
            returnList.add(new ActiveRegion(this.engine.getGenomeLocParser().createGenomeLoc(firstIsActiveStart.getContig(), firstIsActiveStart.getStart(), firstIsActiveStart.getStart()), activeList.get(0) > 0.2, this.engine.getGenomeLocParser(), activeRegionExtension));
            return returnList;
        }
        Double[] activeProbArray = activeList.toArray(new Double[activeList.size()]);
        double[] filteredProbArray = new double[activeProbArray.length];
        int FILTER_SIZE = presetRegions ? 0 : 50;
        int MAX_ACTIVE_REGION = presetRegions ? 16001 : 425;
        for (int iii = 0; iii < activeProbArray.length; ++iii) {
            double maxVal = 0.0;
            for (int jjj = Math.max(0, iii - FILTER_SIZE); jjj < Math.min(activeList.size(), iii + FILTER_SIZE + 1); ++jjj) {
                if (!(activeProbArray[jjj] > maxVal)) continue;
                maxVal = activeProbArray[jjj];
            }
            filteredProbArray[iii] = maxVal;
        }
        boolean curStatus = filteredProbArray[0] > 0.2;
        int curStart = 0;
        for (int iii = 1; iii < filteredProbArray.length; ++iii) {
            boolean thisStatus;
            boolean bl = thisStatus = filteredProbArray[iii] > 0.2;
            if (curStatus == thisStatus && iii - curStart <= MAX_ACTIVE_REGION) continue;
            returnList.add(new ActiveRegion(this.engine.getGenomeLocParser().createGenomeLoc(firstIsActiveStart.getContig(), firstIsActiveStart.getStart() + curStart, firstIsActiveStart.getStart() + (iii - 1)), curStatus, this.engine.getGenomeLocParser(), activeRegionExtension));
            curStatus = thisStatus;
            curStart = iii;
        }
        if (curStart != filteredProbArray.length - 1) {
            returnList.add(new ActiveRegion(this.engine.getGenomeLocParser().createGenomeLoc(firstIsActiveStart.getContig(), firstIsActiveStart.getStart() + curStart, firstIsActiveStart.getStart() + (filteredProbArray.length - 1)), curStatus, this.engine.getGenomeLocParser(), activeRegionExtension));
        }
        return returnList;
    }
}

