/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatibleWalker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.ExperimentalAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class GCContent
extends InfoFieldAnnotation
implements ExperimentalAnnotation {
    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatibleWalker walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc) {
        double content = GCContent.computeGCContent(ref);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getKeyNames().get(0), String.format("%.2f", content));
        return map;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("GC");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine("GC", 1, VCFHeaderLineType.Integer, "GC content within 20 bp +/- the variant"));
    }

    public boolean useZeroQualityReads() {
        return false;
    }

    private static double computeGCContent(ReferenceContext ref) {
        int gc = 0;
        int at = 0;
        for (byte base : ref.getBases()) {
            int baseIndex = BaseUtils.simpleBaseToBaseIndex(base);
            if (baseIndex == BaseUtils.gIndex || baseIndex == BaseUtils.cIndex) {
                ++gc;
                continue;
            }
            if (baseIndex != BaseUtils.aIndex && baseIndex != BaseUtils.tIndex) continue;
            ++at;
        }
        int sum = gc + at;
        return 100.0 * (double)gc / (double)(sum == 0 ? 1 : sum);
    }
}

