/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diagnostics.targets;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.IntervalBinding;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.By;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.gatk.walkers.diagnostics.targets.IntervalStatisticLocus;
import org.broadinstitute.sting.gatk.walkers.diagnostics.targets.IntervalStatistics;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocComparator;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.exceptions.UserException;

@By(value=DataSource.READS)
public class DiagnoseTargets
extends LocusWalker<Long, Long> {
    @Input(fullName="interval_track", shortName="int", doc="", required=true)
    private IntervalBinding<Feature> intervalTrack = null;
    @Output
    private PrintStream out = System.out;
    @Argument(fullName="expand_interval", shortName="exp", doc="", required=false)
    private int expandInterval = 50;
    @Argument(fullName="minimum_base_quality", shortName="mbq", doc="", required=false)
    private int minimumBaseQuality = 20;
    @Argument(fullName="minimum_mapping_quality", shortName="mmq", doc="", required=false)
    private int minimumMappingQuality = 20;
    @Argument(fullName="minimum_coverage", shortName="mincov", doc="", required=false)
    private int minimumCoverage = 5;
    @Argument(fullName="maximum_coverage", shortName="maxcov", doc="", required=false)
    private int maximumCoverage = 700;
    private TreeSet<GenomeLoc> intervalList = null;
    private HashMap<GenomeLoc, IntervalStatistics> intervalMap = null;
    private Iterator<GenomeLoc> intervalListIterator;
    private GenomeLoc currentInterval = null;
    private IntervalStatistics currentIntervalStatistics = null;
    private GenomeLocParser parser;

    @Override
    public void initialize() {
        super.initialize();
        if (this.intervalTrack == null) {
            throw new UserException("This tool currently only works if you provide an interval track");
        }
        this.parser = new GenomeLocParser(this.getToolkit().getMasterSequenceDictionary());
        List<GenomeLoc> originalList = this.intervalTrack.getIntervals(this.getToolkit());
        this.intervalList = new TreeSet<GenomeLoc>(new GenomeLocComparator());
        this.intervalMap = new HashMap(originalList.size() * 2);
        for (GenomeLoc interval : originalList) {
            this.addAndExpandIntervalToLists(interval);
        }
        this.intervalListIterator = this.intervalList.iterator();
    }

    @Override
    public Long map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        GenomeLoc refLocus = ref.getLocus();
        while (this.currentInterval == null || this.currentInterval.isBefore(refLocus)) {
            if (!this.intervalListIterator.hasNext()) {
                return 0L;
            }
            this.currentInterval = this.intervalListIterator.next();
            this.currentIntervalStatistics = this.intervalMap.get(this.currentInterval);
        }
        if (this.currentInterval.isPast(refLocus)) {
            return 0L;
        }
        byte[] mappingQualities = context.getBasePileup().getMappingQuals();
        byte[] baseQualities = context.getBasePileup().getQuals();
        int coverage = context.getBasePileup().getBaseAndMappingFilteredPileup(this.minimumBaseQuality, this.minimumMappingQuality).depthOfCoverage();
        int rawCoverage = context.size();
        IntervalStatisticLocus locusData = new IntervalStatisticLocus(mappingQualities, baseQualities, coverage, rawCoverage);
        this.currentIntervalStatistics.addLocus(refLocus, locusData);
        return 1L;
    }

    @Override
    public Long reduceInit() {
        return 0L;
    }

    @Override
    public Long reduce(Long value, Long sum) {
        return sum + value;
    }

    @Override
    public void onTraversalDone(Long result) {
        super.onTraversalDone(result);
        this.out.println("Interval\tCallStatus\tCOV\tAVG");
        for (GenomeLoc interval : this.intervalList) {
            IntervalStatistics stats = this.intervalMap.get(interval);
            this.out.println(String.format("%s\t%s\t%d\t%f", new Object[]{interval, stats.callableStatus(), stats.totalCoverage(), stats.averageCoverage()}));
        }
    }

    private GenomeLoc createIntervalBefore(GenomeLoc interval) {
        int start = Math.max(interval.getStart() - this.expandInterval, 0);
        int stop = Math.max(interval.getStart() - 1, 0);
        return this.parser.createGenomeLoc(interval.getContig(), interval.getContigIndex(), start, stop);
    }

    private GenomeLoc createIntervalAfter(GenomeLoc interval) {
        int contigLimit = this.getToolkit().getSAMFileHeader().getSequenceDictionary().getSequence(interval.getContigIndex()).getSequenceLength();
        int start = Math.min(interval.getStop() + 1, contigLimit);
        int stop = Math.min(interval.getStop() + this.expandInterval, contigLimit);
        return this.parser.createGenomeLoc(interval.getContig(), interval.getContigIndex(), start, stop);
    }

    private void addAndExpandIntervalToLists(GenomeLoc interval) {
        if (this.expandInterval > 0) {
            GenomeLoc before = this.createIntervalBefore(interval);
            GenomeLoc after = this.createIntervalAfter(interval);
            this.intervalList.add(before);
            this.intervalList.add(after);
            this.intervalMap.put(before, new IntervalStatistics(before, this.minimumCoverage, this.maximumCoverage, this.minimumMappingQuality, this.minimumBaseQuality));
            this.intervalMap.put(after, new IntervalStatistics(after, this.minimumCoverage, this.maximumCoverage, this.minimumMappingQuality, this.minimumBaseQuality));
        }
        this.intervalList.add(interval);
        this.intervalMap.put(interval, new IntervalStatistics(interval, this.minimumCoverage, this.maximumCoverage, this.minimumMappingQuality, this.minimumBaseQuality));
    }
}

