/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.indels;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.utils.Haplotype;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.clipping.ReadClipper;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;
import org.broadinstitute.sting.utils.variantcontext.Allele;

public class PairHMMIndelErrorModel {
    public static final int BASE_QUAL_THRESHOLD = 20;
    private boolean DEBUG = false;
    private boolean bandedLikelihoods = false;
    private static final int MAX_CACHED_QUAL = 127;
    private static final double[] baseMatchArray;
    private static final double[] baseMismatchArray;
    private static final double LOG_ONE_HALF;
    private static final double END_GAP_COST;
    private static final int START_HRUN_GAP_IDX = 4;
    private static final int MAX_HRUN_GAP_IDX = 20;
    private static final double MIN_GAP_OPEN_PENALTY = 30.0;
    private static final double MIN_GAP_CONT_PENALTY = 10.0;
    private static final double GAP_PENALTY_HRUN_STEP = 1.0;
    private final double[] GAP_OPEN_PROB_TABLE;
    private final double[] GAP_CONT_PROB_TABLE;

    public PairHMMIndelErrorModel(double indelGOP, double indelGCP, boolean deb, boolean bandedLikelihoods) {
        this.DEBUG = deb;
        this.bandedLikelihoods = bandedLikelihoods;
        this.GAP_CONT_PROB_TABLE = new double[20];
        this.GAP_OPEN_PROB_TABLE = new double[20];
        double gop = -indelGOP / 10.0;
        double gcp = -indelGCP / 10.0;
        for (int i = 0; i < 4; ++i) {
            this.GAP_OPEN_PROB_TABLE[i] = gop;
            this.GAP_CONT_PROB_TABLE[i] = gcp;
        }
        double step = 0.1;
        double maxGOP = -3.0;
        double maxGCP = -1.0;
        for (int i = 4; i < 20; ++i) {
            if ((gop += step) > maxGOP) {
                gop = maxGOP;
            }
            if ((gcp += step) > maxGCP) {
                gcp = maxGCP;
            }
            this.GAP_OPEN_PROB_TABLE[i] = gop;
            this.GAP_CONT_PROB_TABLE[i] = gcp;
        }
    }

    private static void getContextHomopolymerLength(byte[] refBytes, int[] hrunArray) {
        int i;
        boolean runCount = false;
        hrunArray[0] = 0;
        int[] hforward = new int[hrunArray.length];
        int[] hreverse = new int[hrunArray.length];
        for (i = 1; i < refBytes.length; ++i) {
            hforward[i] = refBytes[i] == refBytes[i - 1] ? hforward[i - 1] + 1 : 0;
        }
        for (i = refBytes.length - 1; i > 0; --i) {
            if (refBytes[i - 1] != refBytes[i]) continue;
            int n = i - 1;
            hreverse[n] = hreverse[n] + (hreverse[i] + 1);
        }
        for (i = 1; i < refBytes.length; ++i) {
            hrunArray[i] = hforward[i] + hreverse[i];
        }
    }

    private void updateCell(int indI, int indJ, int X_METRIC_LENGTH, int Y_METRIC_LENGTH, byte[] readBases, byte[] readQuals, byte[] haplotypeBases, double[] currentGOP, double[] currentGCP, double[][] matchMetricArray, double[][] XMetricArray, double[][] YMetricArray) {
        if (indI > 0 && indJ > 0) {
            int im1 = indI - 1;
            int jm1 = indJ - 1;
            byte x = readBases[im1];
            byte y = haplotypeBases[jm1];
            int qual = readQuals[im1] < 1 ? 1 : (readQuals[im1] > 127 ? 127 : readQuals[im1]);
            double pBaseRead = x == y ? baseMatchArray[qual] : baseMismatchArray[qual];
            matchMetricArray[indI][indJ] = pBaseRead + MathUtils.approximateLog10SumLog10(new double[]{matchMetricArray[im1][jm1], XMetricArray[im1][jm1], YMetricArray[im1][jm1]});
            double c1 = indJ == Y_METRIC_LENGTH - 1 ? END_GAP_COST : currentGOP[jm1];
            double d1 = indJ == Y_METRIC_LENGTH - 1 ? END_GAP_COST : currentGCP[jm1];
            XMetricArray[indI][indJ] = MathUtils.approximateLog10SumLog10(matchMetricArray[im1][indJ] + c1, XMetricArray[im1][indJ] + d1);
            double c2 = indI == X_METRIC_LENGTH - 1 ? END_GAP_COST : currentGOP[jm1];
            double d2 = indI == X_METRIC_LENGTH - 1 ? END_GAP_COST : currentGCP[jm1];
            YMetricArray[indI][indJ] = MathUtils.approximateLog10SumLog10(matchMetricArray[indI][jm1] + c2, YMetricArray[indI][jm1] + d2);
        }
    }

    private double computeReadLikelihoodGivenHaplotypeAffineGaps(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, double[] currentGOP, double[] currentGCP, int indToStart, double[][] matchMetricArray, double[][] XMetricArray, double[][] YMetricArray) {
        int X_METRIC_LENGTH = readBases.length + 1;
        int Y_METRIC_LENGTH = haplotypeBases.length + 1;
        if (indToStart == 0) {
            int i;
            for (i = 0; i < X_METRIC_LENGTH; ++i) {
                Arrays.fill(matchMetricArray[i], Double.NEGATIVE_INFINITY);
                Arrays.fill(YMetricArray[i], Double.NEGATIVE_INFINITY);
                Arrays.fill(XMetricArray[i], Double.NEGATIVE_INFINITY);
            }
            for (i = 1; i < X_METRIC_LENGTH; ++i) {
                XMetricArray[i][0] = END_GAP_COST * (double)i;
            }
            for (int j = 1; j < Y_METRIC_LENGTH; ++j) {
                YMetricArray[0][j] = END_GAP_COST * (double)j;
            }
            matchMetricArray[0][0] = END_GAP_COST;
            YMetricArray[0][0] = 0.0;
            XMetricArray[0][0] = 0.0;
        }
        if (this.bandedLikelihoods) {
            double DIAG_TOL = 20.0;
            int numDiags = X_METRIC_LENGTH + Y_METRIC_LENGTH - 1;
            int elemsInDiag = Math.min(X_METRIC_LENGTH, Y_METRIC_LENGTH);
            int idxWithMaxElement = 0;
            block3: for (int diag = indToStart; diag < numDiags; ++diag) {
                double bestMetric;
                int el;
                int indI = 0;
                int indJ = diag;
                if (diag >= Y_METRIC_LENGTH) {
                    indI = diag - (Y_METRIC_LENGTH - 1);
                    indJ = Y_METRIC_LENGTH - 1;
                }
                int idxLow = idxWithMaxElement;
                double maxElementInDiag = Double.NEGATIVE_INFINITY;
                if ((indI += idxLow) >= X_METRIC_LENGTH || (indJ -= idxLow) < 0) {
                    --indI;
                    ++indJ;
                }
                for (el = --idxLow; el < elemsInDiag; ++el) {
                    this.updateCell(indI, indJ, X_METRIC_LENGTH, Y_METRIC_LENGTH, readBases, readQuals, haplotypeBases, currentGOP, currentGCP, matchMetricArray, XMetricArray, YMetricArray);
                    bestMetric = MathUtils.max(matchMetricArray[indI][indJ], XMetricArray[indI][indJ], YMetricArray[indI][indJ]);
                    if (bestMetric > maxElementInDiag) {
                        maxElementInDiag = bestMetric;
                        idxWithMaxElement = el;
                    } else if (bestMetric < maxElementInDiag - 20.0 && idxWithMaxElement > 0) break;
                    if (++indI >= X_METRIC_LENGTH || --indJ <= 0) break;
                }
                if (idxLow <= 0) continue;
                indI = 0;
                indJ = diag;
                if (diag >= Y_METRIC_LENGTH) {
                    indI = diag - (Y_METRIC_LENGTH - 1);
                    indJ = Y_METRIC_LENGTH - 1;
                }
                indI += idxLow - 1;
                indJ -= idxLow - 1;
                for (el = idxLow - 1; el >= 0; --el) {
                    this.updateCell(indI, indJ, X_METRIC_LENGTH, Y_METRIC_LENGTH, readBases, readQuals, haplotypeBases, currentGOP, currentGCP, matchMetricArray, XMetricArray, YMetricArray);
                    bestMetric = MathUtils.max(matchMetricArray[indI][indJ], XMetricArray[indI][indJ], YMetricArray[indI][indJ]);
                    if (bestMetric > maxElementInDiag) {
                        maxElementInDiag = bestMetric;
                        idxWithMaxElement = el;
                    } else if (bestMetric < maxElementInDiag - 20.0) continue block3;
                    if (++indJ >= Y_METRIC_LENGTH || --indI <= 0) continue block3;
                }
            }
        } else {
            for (int indI = 1; indI < X_METRIC_LENGTH; ++indI) {
                for (int indJ = indToStart + 1; indJ < Y_METRIC_LENGTH; ++indJ) {
                    this.updateCell(indI, indJ, X_METRIC_LENGTH, Y_METRIC_LENGTH, readBases, readQuals, haplotypeBases, currentGOP, currentGCP, matchMetricArray, XMetricArray, YMetricArray);
                }
            }
        }
        int bestI = X_METRIC_LENGTH - 1;
        int bestJ = Y_METRIC_LENGTH - 1;
        double bestMetric = MathUtils.approximateLog10SumLog10(new double[]{matchMetricArray[bestI][bestJ], XMetricArray[bestI][bestJ], YMetricArray[bestI][bestJ]});
        return bestMetric;
    }

    private void fillGapProbabilities(int[] hrunProfile, double[] contextLogGapOpenProbabilities, double[] contextLogGapContinuationProbabilities) {
        for (int i = 0; i < hrunProfile.length; ++i) {
            if (hrunProfile[i] >= 20) {
                contextLogGapOpenProbabilities[i] = this.GAP_OPEN_PROB_TABLE[19];
                contextLogGapContinuationProbabilities[i] = this.GAP_CONT_PROB_TABLE[19];
                continue;
            }
            contextLogGapOpenProbabilities[i] = this.GAP_OPEN_PROB_TABLE[hrunProfile[i]];
            contextLogGapContinuationProbabilities[i] = this.GAP_CONT_PROB_TABLE[hrunProfile[i]];
        }
    }

    public synchronized double[] computeReadHaplotypeLikelihoods(ReadBackedPileup pileup, LinkedHashMap<Allele, Haplotype> haplotypeMap, ReferenceContext ref, int eventLength, HashMap<PileupElement, LinkedHashMap<Allele, Double>> indelLikelihoodMap) {
        int numHaplotypes = haplotypeMap.size();
        double[][] readLikelihoods = new double[pileup.getNumberOfElements()][numHaplotypes];
        int[] readCounts = new int[pileup.getNumberOfElements()];
        int readIdx = 0;
        LinkedHashMap<Allele, double[]> gapOpenProbabilityMap = new LinkedHashMap<Allele, double[]>();
        LinkedHashMap<Allele, double[]> gapContProbabilityMap = new LinkedHashMap<Allele, double[]>();
        for (Allele a : haplotypeMap.keySet()) {
            Haplotype haplotype = haplotypeMap.get(a);
            byte[] haplotypeBases = haplotype.getBases();
            double[] contextLogGapOpenProbabilities = new double[haplotypeBases.length];
            double[] contextLogGapContinuationProbabilities = new double[haplotypeBases.length];
            int[] hrunProfile = new int[haplotypeBases.length];
            PairHMMIndelErrorModel.getContextHomopolymerLength(haplotypeBases, hrunProfile);
            this.fillGapProbabilities(hrunProfile, contextLogGapOpenProbabilities, contextLogGapContinuationProbabilities);
            gapOpenProbabilityMap.put(a, contextLogGapOpenProbabilities);
            gapContProbabilityMap.put(a, contextLogGapContinuationProbabilities);
        }
        for (PileupElement p : pileup) {
            readCounts[readIdx] = p.getRepresentativeCount();
            if (indelLikelihoodMap.containsKey(p)) {
                HashMap el = indelLikelihoodMap.get(p);
                int j = 0;
                for (Allele a : haplotypeMap.keySet()) {
                    readLikelihoods[readIdx][j++] = (Double)el.get(a);
                }
            } else {
                int i;
                GATKSAMRecord read = ReadClipper.hardClipAdaptorSequence(p.getRead());
                if (read.isEmpty() || ReadUtils.is454Read(read)) continue;
                int trailingBases = 3;
                long readStart = read.getUnclippedStart();
                long readEnd = read.getUnclippedEnd();
                long eventStartPos = ref.getLocus().getStart();
                int numStartSoftClippedBases = read.getAlignmentStart() - read.getUnclippedStart();
                int numEndSoftClippedBases = read.getUnclippedEnd() - read.getAlignmentEnd();
                Cigar c = read.getCigar();
                CigarElement first = c.getCigarElement(0);
                CigarElement last = c.getCigarElement(c.numCigarElements() - 1);
                int numStartHardClippedBases = 0;
                int numEndHardClippedBases = 0;
                if (first.getOperator() == CigarOperator.H) {
                    numStartHardClippedBases = first.getLength();
                }
                if (last.getOperator() == CigarOperator.H) {
                    numEndHardClippedBases = last.getLength();
                }
                numStartSoftClippedBases -= numStartHardClippedBases;
                numEndSoftClippedBases -= numEndHardClippedBases;
                readStart += (long)numStartHardClippedBases;
                readEnd -= (long)numEndHardClippedBases;
                if ((long)read.getAlignmentStart() >= eventStartPos - (long)eventLength && (long)read.getAlignmentStart() <= eventStartPos + 1L || (long)read.getAlignmentEnd() >= eventStartPos && (long)read.getAlignmentEnd() <= eventStartPos + (long)eventLength) {
                    numStartSoftClippedBases = 0;
                    numEndSoftClippedBases = 0;
                }
                int numStartClippedBases = numStartSoftClippedBases;
                int numEndClippedBases = numEndSoftClippedBases;
                byte[] unclippedReadBases = read.getReadBases();
                byte[] unclippedReadQuals = read.getBaseQualities();
                for (i = numStartSoftClippedBases; i < unclippedReadBases.length && unclippedReadQuals[i] < 20; ++i) {
                    ++numStartClippedBases;
                }
                for (i = unclippedReadBases.length - numEndSoftClippedBases - 1; i >= 0 && unclippedReadQuals[i] < 20; --i) {
                    ++numEndClippedBases;
                }
                int extraOffset = Math.abs(eventLength);
                long start = Math.max(readStart + (long)numStartClippedBases - 3L - (long)ReadUtils.getFirstInsertionOffset(read) - (long)extraOffset, 0L);
                long stop = readEnd - (long)numEndClippedBases + 3L + (long)ReadUtils.getLastInsertionOffset(read) + (long)extraOffset;
                int readLength = read.getReadLength() - numStartSoftClippedBases - numEndSoftClippedBases;
                if (start < (long)ref.getWindow().getStart()) {
                    start = ref.getWindow().getStart();
                }
                if (stop > (long)ref.getWindow().getStop()) {
                    stop = ref.getWindow().getStop();
                }
                if (stop <= start + (long)readLength) {
                    stop = start + (long)readLength - 1L;
                }
                LinkedHashMap<Allele, Double> readEl = new LinkedHashMap<Allele, Double>();
                if (numStartClippedBases + numEndClippedBases >= unclippedReadBases.length) {
                    int j = 0;
                    for (Allele a : haplotypeMap.keySet()) {
                        readEl.put(a, 0.0);
                        readLikelihoods[readIdx][j++] = 0.0;
                    }
                } else {
                    byte[] readBases = Arrays.copyOfRange(unclippedReadBases, numStartClippedBases, unclippedReadBases.length - numEndClippedBases);
                    byte[] readQuals = Arrays.copyOfRange(unclippedReadQuals, numStartClippedBases, unclippedReadBases.length - numEndClippedBases);
                    int j = 0;
                    double[][] matchMetricArray = null;
                    double[][] XMetricArray = null;
                    double[][] YMetricArray = null;
                    byte[] previousHaplotypeSeen = null;
                    double[] previousGOP = null;
                    double[] previousGCP = null;
                    for (Allele a : haplotypeMap.keySet()) {
                        double readLikelihood;
                        Haplotype haplotype = haplotypeMap.get(a);
                        if (stop > haplotype.getStopPosition()) {
                            stop = haplotype.getStopPosition();
                        }
                        if (start < haplotype.getStartPosition()) {
                            start = haplotype.getStartPosition();
                        }
                        long indStart = start - haplotype.getStartPosition();
                        long indStop = stop - haplotype.getStartPosition();
                        if (this.DEBUG) {
                            System.out.format("indStart: %d indStop: %d WinStart:%d WinStop:%d start: %d stop: %d readLength: %d C:%s\n", indStart, indStop, ref.getWindow().getStart(), ref.getWindow().getStop(), start, stop, read.getReadLength(), read.getCigar().toString());
                        }
                        if (indStart < 0L || indStop >= (long)haplotype.getBases().length || indStart > indStop) {
                            readLikelihood = 0.0;
                        } else {
                            int startIdx;
                            byte[] haplotypeBases = Arrays.copyOfRange(haplotype.getBases(), (int)indStart, (int)indStop);
                            if (matchMetricArray == null) {
                                int X_METRIC_LENGTH = readBases.length + 1;
                                int Y_METRIC_LENGTH = haplotypeBases.length + 1;
                                matchMetricArray = new double[X_METRIC_LENGTH][Y_METRIC_LENGTH];
                                XMetricArray = new double[X_METRIC_LENGTH][Y_METRIC_LENGTH];
                                YMetricArray = new double[X_METRIC_LENGTH][Y_METRIC_LENGTH];
                            }
                            double[] currentContextGOP = Arrays.copyOfRange((double[])gapOpenProbabilityMap.get(a), (int)indStart, (int)indStop);
                            double[] currentContextGCP = Arrays.copyOfRange((double[])gapContProbabilityMap.get(a), (int)indStart, (int)indStop);
                            if (previousHaplotypeSeen == null) {
                                startIdx = 0;
                            } else {
                                int s1 = this.computeFirstDifferingPosition(haplotypeBases, previousHaplotypeSeen);
                                int s2 = this.computeFirstDifferingPosition(currentContextGOP, previousGOP);
                                int s3 = this.computeFirstDifferingPosition(currentContextGCP, previousGCP);
                                startIdx = Math.min(Math.min(s1, s2), s3);
                            }
                            previousHaplotypeSeen = (byte[])haplotypeBases.clone();
                            previousGOP = (double[])currentContextGOP.clone();
                            previousGCP = (double[])currentContextGCP.clone();
                            readLikelihood = this.computeReadLikelihoodGivenHaplotypeAffineGaps(haplotypeBases, readBases, readQuals, currentContextGOP, currentContextGCP, startIdx, matchMetricArray, XMetricArray, YMetricArray);
                            if (this.DEBUG) {
                                System.out.println("H:" + new String(haplotypeBases));
                                System.out.println("R:" + new String(readBases));
                                System.out.format("L:%4.2f\n", readLikelihood);
                                System.out.format("StPos:%d\n", startIdx);
                            }
                        }
                        readEl.put(a, readLikelihood);
                        readLikelihoods[readIdx][j++] = readLikelihood;
                    }
                }
                indelLikelihoodMap.put(p, readEl);
            }
            ++readIdx;
        }
        if (this.DEBUG) {
            System.out.println("\nLikelihood summary");
            for (readIdx = 0; readIdx < pileup.getNumberOfElements(); ++readIdx) {
                System.out.format("Read Index: %d ", readIdx);
                for (int i = 0; i < readLikelihoods[readIdx].length; ++i) {
                    System.out.format("L%d: %f ", i, readLikelihoods[readIdx][i]);
                }
                System.out.println();
            }
        }
        return PairHMMIndelErrorModel.getHaplotypeLikelihoods(numHaplotypes, readCounts, readLikelihoods);
    }

    private int computeFirstDifferingPosition(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            return 0;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return i;
        }
        return b1.length;
    }

    private int computeFirstDifferingPosition(double[] b1, double[] b2) {
        if (b1.length != b2.length) {
            return 0;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (MathUtils.compareDoubles(b1[i], b2[i]) == 0) continue;
            return i;
        }
        return b1.length;
    }

    private static final double[] getHaplotypeLikelihoods(int numHaplotypes, int[] readCounts, double[][] readLikelihoods) {
        double[][] haplotypeLikehoodMatrix = new double[numHaplotypes][numHaplotypes];
        for (int i = 0; i < numHaplotypes; ++i) {
            for (int j = i; j < numHaplotypes; ++j) {
                for (int readIdx = 0; readIdx < readLikelihoods.length; ++readIdx) {
                    if (Double.isInfinite(readLikelihoods[readIdx][i]) && Double.isInfinite(readLikelihoods[readIdx][j])) continue;
                    double li = readLikelihoods[readIdx][i];
                    double lj = readLikelihoods[readIdx][j];
                    int readCount = readCounts[readIdx];
                    double[] dArray = haplotypeLikehoodMatrix[i];
                    int n = j;
                    dArray[n] = dArray[n] + (double)readCount * (MathUtils.approximateLog10SumLog10(li, lj) + LOG_ONE_HALF);
                }
            }
        }
        double[] genotypeLikelihoods = new double[numHaplotypes * (numHaplotypes + 1) / 2];
        int k = 0;
        for (int j = 0; j < numHaplotypes; ++j) {
            for (int i = 0; i <= j; ++i) {
                genotypeLikelihoods[k++] = haplotypeLikehoodMatrix[i][j];
            }
        }
        return MathUtils.normalizeFromLog10(genotypeLikelihoods, false, true);
    }

    static {
        END_GAP_COST = LOG_ONE_HALF = -Math.log10(2.0);
        baseMatchArray = new double[128];
        baseMismatchArray = new double[128];
        for (int k = 1; k <= 127; ++k) {
            double baseProb = Math.pow(10.0, (double)(-k) / 10.0);
            PairHMMIndelErrorModel.baseMatchArray[k] = Math.log10(1.0 - baseProb);
            PairHMMIndelErrorModel.baseMismatchArray[k] = Math.log10(baseProb);
        }
    }
}

