/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.qc;

import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class ErrorThrowingWalker
extends RodWalker<Integer, Integer>
implements TreeReducible<Integer> {
    @Input(fullName="exception", shortName="E", doc="Java class of exception to throw", required=true)
    public String exceptionToThrow;

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (this.exceptionToThrow.equals("UserException")) {
            throw new UserException("UserException");
        }
        if (this.exceptionToThrow.equals("NullPointerException")) {
            throw new NullPointerException();
        }
        if (this.exceptionToThrow.equals("ReviewedStingException")) {
            throw new ReviewedStingException("ReviewedStingException");
        }
        throw new UserException.BadArgumentValue("exception", "exception isn't a recognized value " + this.exceptionToThrow);
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return value + sum;
    }

    @Override
    public Integer treeReduce(Integer lhs, Integer rhs) {
        return lhs + rhs;
    }
}

