/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval;

import com.google.java.contract.Requires;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.picard.util.IntervalTree;
import net.sf.samtools.SAMSequenceRecord;
import org.apache.log4j.Logger;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.IntervalBinding;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.commandline.Tags;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.arguments.DbsnpArgumentCollection;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.report.GATKReport;
import org.broadinstitute.sting.gatk.report.GATKReportTable;
import org.broadinstitute.sting.gatk.walkers.Reference;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;
import org.broadinstitute.sting.gatk.walkers.Window;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.IntervalStratification;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.AnalysisModuleScanner;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.DataPoint;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.NewEvaluationContext;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.SortableJexlVCMatchExp;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.StateKey;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.TableType;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.VariantEvalUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

@Reference(window=@Window(start=-50, stop=50))
public class VariantEvalWalker
extends RodWalker<Integer, Integer>
implements TreeReducible<Integer> {
    @Output
    protected PrintStream out;
    @Input(fullName="eval", shortName="eval", doc="Input evaluation file(s)", required=true)
    public List<RodBinding<VariantContext>> evals;
    @Input(fullName="comp", shortName="comp", doc="Input comparison file(s)", required=false)
    public List<RodBinding<VariantContext>> compsProvided = Collections.emptyList();
    private List<RodBinding<VariantContext>> comps = new ArrayList<RodBinding<VariantContext>>();
    @ArgumentCollection
    protected DbsnpArgumentCollection dbsnp = new DbsnpArgumentCollection();
    @Argument(fullName="list", shortName="ls", doc="List the available eval modules and exit", required=false)
    protected Boolean LIST = false;
    @Argument(shortName="select", doc="One or more stratifications to use when evaluating the data", required=false)
    protected ArrayList<String> SELECT_EXPS = new ArrayList();
    @Argument(shortName="selectName", doc="Names to use for the list of stratifications (must be a 1-to-1 mapping)", required=false)
    protected ArrayList<String> SELECT_NAMES = new ArrayList();
    @Argument(fullName="sample", shortName="sn", doc="Derive eval and comp contexts using only these sample genotypes, when genotypes are available in the original context", required=false)
    protected Set<String> SAMPLE_EXPRESSIONS;
    @Argument(shortName="knownName", doc="Name of ROD bindings containing variant sites that should be treated as known when splitting eval rods into known and novel subsets", required=false)
    protected HashSet<String> KNOWN_NAMES = new HashSet();
    List<RodBinding<VariantContext>> knowns = new ArrayList<RodBinding<VariantContext>>();
    @Argument(fullName="stratificationModule", shortName="ST", doc="One or more specific stratification modules to apply to the eval track(s) (in addition to the standard stratifications, unless -noS is specified)", required=false)
    protected String[] STRATIFICATIONS_TO_USE = new String[0];
    @Argument(fullName="doNotUseAllStandardStratifications", shortName="noST", doc="Do not use the standard stratification modules by default (instead, only those that are specified with the -S option)", required=false)
    protected Boolean NO_STANDARD_STRATIFICATIONS = false;
    @Argument(fullName="evalModule", shortName="EV", doc="One or more specific eval modules to apply to the eval track(s) (in addition to the standard modules, unless -noEV is specified)", required=false)
    protected String[] MODULES_TO_USE = new String[0];
    @Argument(fullName="doNotUseAllStandardModules", shortName="noEV", doc="Do not use the standard modules by default (instead, only those that are specified with the -EV option)", required=false)
    protected Boolean NO_STANDARD_MODULES = false;
    @Argument(fullName="numSamples", shortName="ns", doc="Number of samples (used if no samples are available in the VCF file", required=false)
    protected Integer NUM_SAMPLES = 0;
    @Argument(fullName="minPhaseQuality", shortName="mpq", doc="Minimum phasing quality", required=false)
    protected double MIN_PHASE_QUALITY = 10.0;
    @Argument(shortName="mvq", fullName="mendelianViolationQualThreshold", doc="Minimum genotype QUAL score for each trio member required to accept a site as a violation. Default is 50.", required=false)
    protected double MENDELIAN_VIOLATION_QUAL_THRESHOLD = 50.0;
    @Argument(fullName="ancestralAlignments", shortName="aa", doc="Fasta file with ancestral alleles", required=false)
    private File ancestralAlignmentsFile = null;
    @Argument(fullName="requireStrictAlleleMatch", shortName="strict", doc="If provided only comp and eval tracks with exactly matching reference and alternate alleles will be counted as overlapping", required=false)
    private boolean requireStrictAlleleMatch = false;
    @Argument(fullName="mergeEvals", shortName="mergeEvals", doc="If provided, all -eval tracks will be merged into a single eval track", required=false)
    public boolean mergeEvals = false;
    @Input(fullName="stratIntervals", shortName="stratIntervals", doc="File containing tribble-readable features for the IntervalStratificiation", required=false)
    public IntervalBinding<Feature> intervalsFile = null;
    @Input(fullName="knownCNVs", shortName="knownCNVs", doc="File containing tribble-readable features describing a known list of copy number variants", required=false)
    public IntervalBinding<Feature> knownCNVsFile = null;
    Map<String, IntervalTree<GenomeLoc>> knownCNVsByContig = Collections.emptyMap();
    private Set<SortableJexlVCMatchExp> jexlExpressions = new TreeSet<SortableJexlVCMatchExp>();
    private Set<String> sampleNamesForEvaluation = new TreeSet<String>();
    private Set<String> sampleNamesForStratification = new TreeSet<String>();
    private int numSamples = 0;
    private TreeSet<VariantStratifier> stratificationObjects = null;
    private HashMap<StateKey, NewEvaluationContext> evaluationContexts = null;
    private boolean byFilterIsEnabled = false;
    private boolean perSampleIsEnabled = false;
    private GATKReport report = null;
    private static String ALL_SAMPLE_NAME = "all";
    private final VariantEvalUtils variantEvalUtils = new VariantEvalUtils(this);
    private IndexedFastaSequenceFile ancestralAlignments = null;

    @Override
    public void initialize() {
        if (this.LIST.booleanValue()) {
            this.variantEvalUtils.listModulesAndExit();
        }
        this.comps.addAll(this.compsProvided);
        if (this.dbsnp.dbsnp.isBound()) {
            this.comps.add(this.dbsnp.dbsnp);
            this.knowns.add(this.dbsnp.dbsnp);
        }
        if (this.comps.size() == 0) {
            this.comps.add(new RodBinding<VariantContext>(VariantContext.class, "none", "UNBOUND", "", new Tags()));
        }
        for (RodBinding<VariantContext> compRod : this.comps) {
            if (!this.KNOWN_NAMES.contains(compRod.getName())) continue;
            this.knowns.add(compRod);
        }
        Map<String, VCFHeader> vcfRods = VCFUtils.getVCFHeadersFromRods(this.getToolkit(), this.evals);
        Set<String> vcfSamples = SampleUtils.getSampleList(vcfRods, VariantContextUtils.GenotypeMergeType.REQUIRE_UNIQUE);
        this.sampleNamesForEvaluation.addAll(SampleUtils.getSamplesFromCommandLineInput(vcfSamples, this.SAMPLE_EXPRESSIONS));
        int n = this.numSamples = this.NUM_SAMPLES > 0 ? this.NUM_SAMPLES.intValue() : this.sampleNamesForEvaluation.size();
        if (Arrays.asList(this.STRATIFICATIONS_TO_USE).contains("Sample")) {
            this.sampleNamesForStratification.addAll(this.sampleNamesForEvaluation);
        }
        this.sampleNamesForStratification.add(ALL_SAMPLE_NAME);
        for (VariantContextUtils.JexlVCMatchExp jexl : VariantContextUtils.initializeMatchExps(this.SELECT_NAMES, this.SELECT_EXPS)) {
            SortableJexlVCMatchExp sjexl = new SortableJexlVCMatchExp(jexl.name, jexl.exp);
            this.jexlExpressions.add(sjexl);
        }
        this.stratificationObjects = this.variantEvalUtils.initializeStratificationObjects(this, this.NO_STANDARD_STRATIFICATIONS, this.STRATIFICATIONS_TO_USE);
        Set<Class<? extends VariantEvaluator>> evaluationObjects = this.variantEvalUtils.initializeEvaluationObjects(this.NO_STANDARD_MODULES, this.MODULES_TO_USE);
        for (VariantStratifier vs : this.getStratificationObjects()) {
            if (vs.getName().equals("Filter")) {
                this.byFilterIsEnabled = true;
                continue;
            }
            if (!vs.getName().equals("Sample")) continue;
            this.perSampleIsEnabled = true;
        }
        if (this.intervalsFile != null) {
            boolean fail = true;
            for (VariantStratifier vs : this.stratificationObjects) {
                if (!vs.getClass().equals(IntervalStratification.class)) continue;
                fail = false;
            }
            if (fail) {
                throw new UserException.BadArgumentValue("ST", "stratIntervals argument provided but -ST IntervalStratification not provided");
            }
        }
        this.evaluationContexts = this.variantEvalUtils.initializeEvaluationContexts(this.stratificationObjects, evaluationObjects, null, null);
        this.report = this.variantEvalUtils.initializeGATKReport(this.stratificationObjects, evaluationObjects);
        if (this.ancestralAlignmentsFile != null) {
            try {
                this.ancestralAlignments = new IndexedFastaSequenceFile(this.ancestralAlignmentsFile);
            }
            catch (FileNotFoundException e) {
                throw new ReviewedStingException(String.format("The ancestral alignments file, '%s', could not be found", this.ancestralAlignmentsFile.getAbsolutePath()));
            }
        }
        if (this.knownCNVsFile != null) {
            this.knownCNVsByContig = this.createIntervalTreeByContig(this.knownCNVsFile);
        }
    }

    public final Map<String, IntervalTree<GenomeLoc>> createIntervalTreeByContig(IntervalBinding<Feature> intervals) {
        HashMap<String, IntervalTree<GenomeLoc>> byContig = new HashMap<String, IntervalTree<GenomeLoc>>();
        List<GenomeLoc> locs = intervals.getIntervals(this.getToolkit());
        for (String contig : this.getContigNames()) {
            byContig.put(contig, new IntervalTree());
        }
        for (GenomeLoc loc : locs) {
            ((IntervalTree)byContig.get(loc.getContig())).put(loc.getStart(), loc.getStop(), loc);
        }
        return byContig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        Iterator<NewEvaluationContext> i$ = this.evaluationContexts.values().iterator();
        while (i$.hasNext()) {
            NewEvaluationContext nec;
            NewEvaluationContext newEvaluationContext = nec = i$.next();
            synchronized (newEvaluationContext) {
                nec.update0(tracker, ref, context);
            }
        }
        if (tracker != null) {
            String aastr = this.ancestralAlignments == null ? null : new String(this.ancestralAlignments.getSubsequenceAt(ref.getLocus().getContig(), ref.getLocus().getStart(), ref.getLocus().getStop()).getBases());
            HashMap<RodBinding<VariantContext>, HashMap<String, Collection<VariantContext>>> evalVCs = this.variantEvalUtils.bindVariantContexts(tracker, ref, this.evals, this.byFilterIsEnabled, true, this.perSampleIsEnabled, this.mergeEvals);
            HashMap<RodBinding<VariantContext>, HashMap<String, Collection<VariantContext>>> compVCs = this.variantEvalUtils.bindVariantContexts(tracker, ref, this.comps, this.byFilterIsEnabled, false, false, false);
            for (RodBinding<VariantContext> evalRod : this.evals) {
                Map emptyEvalMap = Collections.emptyMap();
                Map evalSet = evalVCs.containsKey(evalRod) ? (Map)evalVCs.get(evalRod) : emptyEvalMap;
                for (String sampleName : this.sampleNamesForStratification) {
                    HashSet<VariantContext> evalSetBySample = (HashSet<VariantContext>)evalSet.get(sampleName);
                    if (evalSetBySample == null) {
                        evalSetBySample = new HashSet<VariantContext>(1);
                        evalSetBySample.add(null);
                    }
                    for (VariantContext eval : evalSetBySample) {
                        if (eval != null && aastr != null) {
                            eval = new VariantContextBuilder(eval).attribute("ANCESTRALALLELE", aastr).make();
                        }
                        for (RodBinding<VariantContext> compRod : this.comps) {
                            HashMap<String, Collection<VariantContext>> compSetHash = compVCs.get(compRod);
                            List<VariantContext> compSet = compSetHash == null || compSetHash.size() == 0 ? Collections.emptyList() : compVCs.get(compRod).values().iterator().next();
                            VariantContext comp = this.findMatchingComp(eval, compSet);
                            HashMap<VariantStratifier, List<String>> stateMap = new HashMap<VariantStratifier, List<String>>();
                            for (VariantStratifier vs : this.stratificationObjects) {
                                List<String> states = vs.getRelevantStates(ref, tracker, comp, compRod.getName(), eval, evalRod.getName(), sampleName);
                                stateMap.put(vs, states);
                            }
                            ArrayList<StateKey> stateKeys = new ArrayList<StateKey>();
                            this.variantEvalUtils.initializeStateKeys(stateMap, null, null, stateKeys);
                            HashSet<StateKey> stateKeysHash = new HashSet<StateKey>(stateKeys);
                            for (StateKey stateKey : stateKeysHash) {
                                NewEvaluationContext nec;
                                NewEvaluationContext newEvaluationContext = nec = this.evaluationContexts.get(stateKey);
                                synchronized (newEvaluationContext) {
                                    nec.apply(tracker, ref, context, comp, eval);
                                }
                                for (VariantContext otherComp : compSet) {
                                    if (otherComp == comp || this.compHasMatchingEval(otherComp, evalSetBySample)) continue;
                                    NewEvaluationContext newEvaluationContext2 = nec;
                                    synchronized (newEvaluationContext2) {
                                        nec.apply(tracker, ref, context, otherComp, null);
                                    }
                                }
                            }
                        }
                    }
                }
                if (!this.mergeEvals) continue;
                break;
            }
        }
        return null;
    }

    @Requires(value={"comp != null", "evals != null"})
    private boolean compHasMatchingEval(VariantContext comp, Collection<VariantContext> evals) {
        for (VariantContext eval : evals) {
            if (eval == null || this.doEvalAndCompMatch(comp, eval, this.requireStrictAlleleMatch) == EvalCompMatchType.NO_MATCH) continue;
            return true;
        }
        return false;
    }

    @Requires(value={"eval != null", "comp != null"})
    private EvalCompMatchType doEvalAndCompMatch(VariantContext eval, VariantContext comp, boolean requireStrictAlleleMatch) {
        Allele altComp;
        if (comp.getType() != eval.getType()) {
            return EvalCompMatchType.NO_MATCH;
        }
        Allele altEval = eval.getAlternateAlleles().size() == 0 ? null : eval.getAlternateAllele(0);
        Allele allele = altComp = comp.getAlternateAlleles().size() == 0 ? null : comp.getAlternateAllele(0);
        if (altEval == null && altComp == null || altEval != null && altEval.equals(altComp) && eval.getReference().equals(comp.getReference())) {
            return EvalCompMatchType.STRICT;
        }
        return requireStrictAlleleMatch ? EvalCompMatchType.NO_MATCH : EvalCompMatchType.LENIENT;
    }

    private VariantContext findMatchingComp(VariantContext eval, Collection<VariantContext> comps) {
        if (comps == null || comps.isEmpty()) {
            return null;
        }
        if (eval == null) {
            return comps.iterator().next();
        }
        VariantContext lenientMatch = null;
        for (VariantContext comp : comps) {
            switch (this.doEvalAndCompMatch(comp, eval, this.requireStrictAlleleMatch)) {
                case STRICT: {
                    return comp;
                }
                case LENIENT: {
                    if (lenientMatch != null) break;
                    lenientMatch = comp;
                    break;
                }
            }
        }
        return lenientMatch;
    }

    @Override
    public Integer treeReduce(Integer lhs, Integer rhs) {
        return null;
    }

    @Override
    public Integer reduceInit() {
        return null;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return null;
    }

    @Override
    public void onTraversalDone(Integer result) {
        logger.info("Finalizing variant report");
        for (StateKey stateKey : this.evaluationContexts.keySet()) {
            NewEvaluationContext nec = this.evaluationContexts.get(stateKey);
            for (VariantEvaluator ve : nec.getEvaluationClassList().values()) {
                ve.finalizeEvaluation();
                AnalysisModuleScanner scanner = new AnalysisModuleScanner(ve);
                Map<Field, DataPoint> datamap = scanner.getData();
                for (Field field : datamap.keySet()) {
                    try {
                        field.setAccessible(true);
                        if (field.get(ve) instanceof TableType) {
                            GATKReportTable table;
                            TableType t = (TableType)field.get(ve);
                            String subTableName = ve.getClass().getSimpleName() + "." + field.getName();
                            DataPoint dataPointAnn = datamap.get(field);
                            if (!this.report.hasTable(subTableName)) {
                                this.report.addTable(subTableName, dataPointAnn.description());
                                table = this.report.getTable(subTableName);
                                table.addPrimaryKey("entry", false);
                                table.addColumn(subTableName, subTableName);
                                for (VariantStratifier vs : this.stratificationObjects) {
                                    table.addColumn(vs.getName(), "unknown");
                                }
                                table.addColumn("row", "unknown");
                                for (Object o : t.getColumnKeys()) {
                                    String c = o instanceof String ? (String)o : o.toString();
                                    table.addColumn(c, 0.0);
                                }
                            } else {
                                table = this.report.getTable(subTableName);
                            }
                            for (int row = 0; row < t.getRowKeys().length; ++row) {
                                String r = (String)t.getRowKeys()[row];
                                for (VariantStratifier vs : this.stratificationObjects) {
                                    String columnName = vs.getName();
                                    table.set(stateKey.toString() + r, columnName, stateKey.get(columnName));
                                }
                                for (int col = 0; col < t.getColumnKeys().length; ++col) {
                                    String c = t.getColumnKeys()[col] instanceof String ? (String)t.getColumnKeys()[col] : t.getColumnKeys()[col].toString();
                                    String newStateKey = stateKey.toString() + r;
                                    table.set(newStateKey, c, t.getCell(row, col));
                                    table.set(newStateKey, "row", r);
                                }
                            }
                            continue;
                        }
                        GATKReportTable table = this.report.getTable(ve.getClass().getSimpleName());
                        for (VariantStratifier vs : this.stratificationObjects) {
                            String columnName = vs.getName();
                            table.set(stateKey.toString(), columnName, stateKey.get(vs.getName()));
                        }
                        table.set(stateKey.toString(), field.getName(), field.get(ve));
                    }
                    catch (IllegalAccessException e) {
                        throw new StingException("IllegalAccessException: " + e);
                    }
                }
            }
        }
        this.report.print(this.out);
    }

    public Logger getLogger() {
        return logger;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public double getMinPhaseQuality() {
        return this.MIN_PHASE_QUALITY;
    }

    public double getMendelianViolationQualThreshold() {
        return this.MENDELIAN_VIOLATION_QUAL_THRESHOLD;
    }

    public TreeSet<VariantStratifier> getStratificationObjects() {
        return this.stratificationObjects;
    }

    public static String getAllSampleName() {
        return ALL_SAMPLE_NAME;
    }

    public List<RodBinding<VariantContext>> getKnowns() {
        return this.knowns;
    }

    public List<RodBinding<VariantContext>> getEvals() {
        return this.evals;
    }

    public Set<String> getSampleNamesForEvaluation() {
        return this.sampleNamesForEvaluation;
    }

    public Set<String> getSampleNamesForStratification() {
        return this.sampleNamesForStratification;
    }

    public List<RodBinding<VariantContext>> getComps() {
        return this.comps;
    }

    public Set<SortableJexlVCMatchExp> getJexlExpressions() {
        return this.jexlExpressions;
    }

    public Set<String> getContigNames() {
        TreeSet<String> contigs = new TreeSet<String>();
        for (SAMSequenceRecord r : this.getToolkit().getReferenceDataSource().getReference().getSequenceDictionary().getSequences()) {
            contigs.add(r.getSequenceName());
        }
        return contigs;
    }

    public GenomeLocParser getGenomeLocParser() {
        return this.getToolkit().getGenomeLocParser();
    }

    @Override
    public GenomeAnalysisEngine getToolkit() {
        return super.getToolkit();
    }

    private static enum EvalCompMatchType {
        NO_MATCH,
        STRICT,
        LENIENT;

    }
}

