/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Analysis;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.DataPoint;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class AnalysisModuleScanner {
    private Map<Field, DataPoint> datums = new LinkedHashMap<Field, DataPoint>();
    private Analysis analysis;
    private final Class cls;

    public AnalysisModuleScanner(Class cls) {
        this.cls = cls;
        this.scan();
    }

    public AnalysisModuleScanner(Object obj) {
        this.cls = obj.getClass();
        this.scan();
    }

    public void scan() {
        if (this.cls == null || !this.cls.isAnnotationPresent(Analysis.class)) {
            throw new ReviewedStingException("The class passed in cannot be null, and must contain the @Analysis annotation, class " + this.cls + " was the input");
        }
        this.analysis = this.cls.getAnnotation(Analysis.class);
        this.scanFields();
    }

    private void scanFields() {
        for (Class superCls = this.cls; superCls != null; superCls = superCls.getSuperclass()) {
            for (Field f : superCls.getDeclaredFields()) {
                for (Annotation annotation : f.getAnnotations()) {
                    if (!annotation.annotationType().equals(DataPoint.class)) continue;
                    this.datums.put(f, (DataPoint)annotation);
                }
            }
        }
    }

    public Map<Field, DataPoint> getData() {
        return this.datums;
    }

    public Analysis getAnalysis() {
        return this.analysis;
    }

    public Class getModuleClass() {
        return this.cls;
    }
}

