/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs.sampileup;

import java.util.List;
import net.sf.samtools.util.StringUtil;
import org.broad.tribble.Feature;

public class SAMPileupFeature
implements Feature {
    private String contig;
    private int start;
    private int stop;
    private char refBaseChar;
    private String refBases;
    private String pileupQuals;
    private String pileupBases;
    private List<String> observedAlleles = null;
    private VariantType varType = VariantType.NONE;
    private int nNonref = 0;
    private int eventLength = 0;
    private double consensusScore = 0.0;
    private double variantScore = 0.0;

    SAMPileupFeature() {
    }

    @Override
    public String getChr() {
        return this.contig;
    }

    protected void setChr(String chr) {
        this.contig = chr;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    protected void setStart(int start) {
        this.start = start;
    }

    @Override
    public int getEnd() {
        return this.stop;
    }

    protected void setEnd(int end) {
        this.stop = end;
    }

    public String getQualsAsString() {
        return this.pileupQuals;
    }

    protected void setPileupQuals(String pileupQuals) {
        this.pileupQuals = pileupQuals;
    }

    public char getRef() {
        return this.refBaseChar;
    }

    protected void setRef(char ref) {
        this.refBaseChar = ref;
    }

    public int size() {
        return this.pileupQuals.length();
    }

    public String getBasesAsString() {
        return this.pileupBases;
    }

    protected void setPileupBases(String pileupBases) {
        this.pileupBases = pileupBases;
    }

    public String getPileupString() {
        if (this.start == this.stop) {
            return String.format("%s:%d: %s %s %s", this.getChr(), this.getStart(), Character.valueOf(this.getRef()), this.getBasesAsString(), this.getQualsAsString());
        }
        return String.format("%s:%d-%d: %s %s %s", this.getChr(), this.getStart(), this.getEnd(), Character.valueOf(this.getRef()), this.getBasesAsString(), this.getQualsAsString());
    }

    public byte[] getBases() {
        return StringUtil.stringToBytes(this.getBasesAsString());
    }

    public byte[] getQuals() {
        byte[] quals = StringUtil.stringToBytes(this.getQualsAsString());
        int i = 0;
        while (i < quals.length) {
            int n = i++;
            quals[n] = (byte)(quals[n] - 33);
        }
        return quals;
    }

    public String getFWDRefBases() {
        return this.refBases;
    }

    protected void setRefBases(String refBases) {
        this.refBases = refBases;
    }

    public List<String> getFWDAlleles() {
        return this.observedAlleles;
    }

    protected void setFWDAlleles(List<String> alleles) {
        this.observedAlleles = alleles;
    }

    public boolean isSNP() {
        return this.varType == VariantType.SNP;
    }

    public boolean isInsertion() {
        return this.varType == VariantType.INSERTION;
    }

    public boolean isDeletion() {
        return this.varType == VariantType.DELETION;
    }

    public boolean isIndel() {
        return this.isInsertion() || this.isDeletion() || this.varType == VariantType.INDEL;
    }

    public boolean isReference() {
        return this.varType == VariantType.NONE;
    }

    protected void setVariantType(VariantType variantType) {
        this.varType = variantType;
    }

    public boolean isHom() {
        if (!this.isIndel()) {
            return this.observedAlleles.get(0).equals(this.observedAlleles.get(1));
        }
        return (this.isInsertion() || this.isDeletion()) && this.observedAlleles.get(0).equals(this.observedAlleles.get(1));
    }

    public boolean isHet() {
        if (!this.isIndel()) {
            return !this.observedAlleles.get(0).equals(this.observedAlleles.get(1));
        }
        return this.isIndel() || !this.observedAlleles.get(0).equals(this.observedAlleles.get(1));
    }

    public double getVariantConfidence() {
        return this.variantScore;
    }

    protected void setVariantConfidence(double variantScore) {
        this.variantScore = variantScore;
    }

    public boolean isBiallelic() {
        return this.nNonref < 2;
    }

    protected void setNumNonRef(int nNonref) {
        this.nNonref = nNonref;
    }

    public double getConsensusConfidence() {
        return this.consensusScore;
    }

    protected void setConsensusConfidence(double consensusScore) {
        this.consensusScore = consensusScore;
    }

    public int length() {
        return this.eventLength;
    }

    protected void setLength(int eventLength) {
        this.eventLength = eventLength;
    }

    public boolean isIndelGenotype() {
        return this.refBaseChar == '*';
    }

    public boolean isPointGenotype() {
        return !this.isIndelGenotype();
    }

    public SAMPileupFeature getIndelGenotype() {
        if (this.isIndelGenotype()) {
            return this;
        }
        return null;
    }

    public SAMPileupFeature getPointGenotype() {
        if (this.isPointGenotype()) {
            return this;
        }
        return null;
    }

    public boolean hasIndelGenotype() {
        return this.isIndelGenotype();
    }

    public boolean hasPointGenotype() {
        return this.isPointGenotype();
    }

    public static enum VariantType {
        NONE,
        SNP,
        INSERTION,
        DELETION,
        INDEL;

    }
}

