/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.io.stubs;

import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import org.broadinstitute.sting.commandline.ArgumentDefinition;
import org.broadinstitute.sting.commandline.ArgumentMatches;
import org.broadinstitute.sting.commandline.ArgumentSource;
import org.broadinstitute.sting.commandline.ArgumentTypeDescriptor;
import org.broadinstitute.sting.commandline.MissingArgumentValueException;
import org.broadinstitute.sting.commandline.ParsingEngine;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.io.stubs.OutputStreamStub;
import org.broadinstitute.sting.utils.exceptions.DynamicClassResolutionException;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class OutputStreamArgumentTypeDescriptor
extends ArgumentTypeDescriptor {
    private final GenomeAnalysisEngine engine;
    private final OutputStream defaultOutputStream;

    public OutputStreamArgumentTypeDescriptor(GenomeAnalysisEngine engine, OutputStream defaultOutputStream) {
        this.engine = engine;
        this.defaultOutputStream = defaultOutputStream;
    }

    @Override
    public boolean supports(Class type) {
        return this.getConstructorForClass(type) != null;
    }

    @Override
    public boolean createsTypeDefault(ArgumentSource source) {
        return source.isRequired();
    }

    @Override
    public String typeDefaultDocString(ArgumentSource source) {
        return "stdout";
    }

    @Override
    public Object createTypeDefault(ParsingEngine parsingEngine, ArgumentSource source, Type type) {
        if (!source.isRequired()) {
            throw new ReviewedStingException("BUG: tried to create type default for argument type descriptor that can't support a type default.");
        }
        OutputStreamStub stub = new OutputStreamStub(this.defaultOutputStream);
        this.engine.addOutput(stub);
        return this.createInstanceOfClass((Class)type, stub);
    }

    @Override
    public Object parse(ParsingEngine parsingEngine, ArgumentSource source, Type type, ArgumentMatches matches) {
        ArgumentDefinition definition = this.createDefaultArgumentDefinition(source);
        String fileName = this.getArgumentValue(definition, matches);
        if (fileName == null && !source.isRequired()) {
            throw new MissingArgumentValueException(definition);
        }
        OutputStreamStub stub = new OutputStreamStub(new File(fileName));
        this.engine.addOutput(stub);
        Object result = this.createInstanceOfClass(this.makeRawTypeIfNecessary(type), stub);
        parsingEngine.addTags(result, this.getArgumentTags(matches));
        return result;
    }

    private Constructor<OutputStream> getConstructorForClass(Class type) {
        try {
            return type.getConstructor(OutputStream.class);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private Object createInstanceOfClass(Class type, OutputStream outputStream) {
        try {
            return this.getConstructorForClass(type).newInstance(outputStream);
        }
        catch (Exception e) {
            throw new DynamicClassResolutionException(type, e);
        }
    }
}

