/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs.vcf;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.NameAwareCodec;
import org.broad.tribble.TribbleException;
import org.broad.tribble.readers.LineReader;
import org.broad.tribble.util.BlockCompressedInputStream;
import org.broad.tribble.util.ParsingUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFCodec;
import org.broadinstitute.sting.utils.codecs.vcf.VCFConstants;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFilterHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFormatHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderVersion;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.LazyGenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;

public abstract class AbstractVCFCodec
implements FeatureCodec,
NameAwareCodec {
    protected static final Logger log = Logger.getLogger(VCFCodec.class);
    protected static final int NUM_STANDARD_FIELDS = 8;
    protected VCFHeaderVersion version;
    protected VCFHeader header = null;
    protected Map<String, List<Allele>> alleleMap = new HashMap<String, List<Allele>>(3);
    protected String[] GTValueArray = new String[100];
    protected String[] genotypeKeyArray = new String[100];
    protected String[] infoFieldArray = new String[1000];
    protected String[] infoValueArray = new String[1000];
    public static boolean validate = true;
    protected String[] parts = null;
    protected String[] genotypeParts = null;
    protected HashMap<String, LinkedHashSet<String>> filterHash = new HashMap();
    TreeMap<String, VCFHeaderLineType> infoFields = new TreeMap();
    TreeMap<String, VCFHeaderLineType> formatFields = new TreeMap();
    Set<String> filterFields = new HashSet<String>();
    protected String name = "Unknown";
    protected int lineNo = 0;
    protected Map<String, String> stringCache = new HashMap<String, String>();

    @Override
    public abstract Object readHeader(LineReader var1);

    public abstract LazyGenotypesContext.LazyData createGenotypeMap(String var1, List<Allele> var2, String var3, int var4);

    protected abstract Set<String> parseFilters(String var1);

    protected Object createHeader(List<String> headerStrings, String line) {
        headerStrings.add(line);
        TreeSet<VCFHeaderLine> metaData = new TreeSet<VCFHeaderLine>();
        LinkedHashSet<String> sampleNames = new LinkedHashSet<String>();
        for (String str : headerStrings) {
            if (!str.startsWith("##")) {
                String[] strings = str.substring(1).split("\t");
                if (strings.length < VCFHeader.HEADER_FIELDS.values().length) {
                    throw new TribbleException.InvalidHeader("there are not enough columns present in the header line: " + str);
                }
                int arrayIndex = 0;
                for (VCFHeader.HEADER_FIELDS field : VCFHeader.HEADER_FIELDS.values()) {
                    try {
                        if (field != VCFHeader.HEADER_FIELDS.valueOf(strings[arrayIndex])) {
                            throw new TribbleException.InvalidHeader("we were expecting column name '" + (Object)((Object)field) + "' but we saw '" + strings[arrayIndex] + "'");
                        }
                    }
                    catch (IllegalArgumentException e) {
                        throw new TribbleException.InvalidHeader("unknown column name '" + strings[arrayIndex] + "'; it does not match a legal column header name.");
                    }
                    ++arrayIndex;
                }
                boolean sawFormatTag = false;
                if (arrayIndex < strings.length) {
                    if (!strings[arrayIndex].equals("FORMAT")) {
                        throw new TribbleException.InvalidHeader("we were expecting column name 'FORMAT' but we saw '" + strings[arrayIndex] + "'");
                    }
                    sawFormatTag = true;
                    ++arrayIndex;
                }
                while (arrayIndex < strings.length) {
                    sampleNames.add(strings[arrayIndex++]);
                }
                if (!sawFormatTag || sampleNames.size() != 0) continue;
                throw new UserException.MalformedVCFHeader("The FORMAT field was provided but there is no genotype/sample data");
            }
            if (str.startsWith("##INFO=")) {
                VCFInfoHeaderLine info = new VCFInfoHeaderLine(str.substring(7), this.version);
                metaData.add(info);
                this.infoFields.put(info.getName(), info.getType());
                continue;
            }
            if (str.startsWith("##FILTER=")) {
                VCFFilterHeaderLine filter = new VCFFilterHeaderLine(str.substring(9), this.version);
                metaData.add(filter);
                this.filterFields.add(filter.getName());
                continue;
            }
            if (str.startsWith("##FORMAT=")) {
                VCFFormatHeaderLine format = new VCFFormatHeaderLine(str.substring(9), this.version);
                metaData.add(format);
                this.formatFields.put(format.getName(), format.getType());
                continue;
            }
            int equals = str.indexOf("=");
            if (equals == -1) continue;
            metaData.add(new VCFHeaderLine(str.substring(2, equals), str.substring(equals + 1)));
        }
        this.header = new VCFHeader(metaData, sampleNames);
        this.header.buildVCFReaderMaps(new ArrayList<String>(sampleNames));
        return this.header;
    }

    @Override
    public Feature decodeLoc(String line) {
        int start;
        if (line.startsWith("#")) {
            return null;
        }
        if (this.header == null) {
            throw new ReviewedStingException("VCF Header cannot be null when decoding a record");
        }
        String[] locParts = new String[6];
        int nParts = ParsingUtils.split(line, locParts, '\t', true);
        if (nParts != 6) {
            throw new UserException.MalformedVCF("there aren't enough columns for line " + line, this.lineNo);
        }
        String ref = this.getCachedString(locParts[3].toUpperCase());
        String alts = this.getCachedString(locParts[4].toUpperCase());
        List<Allele> alleles = AbstractVCFCodec.parseAlleles(ref, alts, this.lineNo);
        int stop = start = Integer.valueOf(locParts[1]).intValue();
        if (alleles.size() == 1) {
            stop = start + alleles.get(0).length() - 1;
        } else if (!AbstractVCFCodec.isSingleNucleotideEvent(alleles)) {
            stop = AbstractVCFCodec.clipAlleles(start, ref, alleles, null, this.lineNo);
        }
        return new VCFLocFeature(locParts[0], start, stop);
    }

    public Feature decode(String line) {
        if (line.startsWith("#")) {
            return null;
        }
        if (this.header == null) {
            throw new ReviewedStingException("VCF Header cannot be null when decoding a record");
        }
        if (this.parts == null) {
            this.parts = new String[Math.min(this.header.getColumnCount(), 9)];
        }
        int nParts = ParsingUtils.split(line, this.parts, '\t', true);
        if ((this.header == null || !this.header.hasGenotypingData()) && nParts != 8 || this.header != null && this.header.hasGenotypingData() && nParts != 9) {
            throw new UserException.MalformedVCF("there aren't enough columns for line " + line + " (we expected " + (this.header == null ? 8 : 9) + " tokens, and saw " + nParts + " )", this.lineNo);
        }
        return this.parseVCFLine(this.parts);
    }

    protected void generateException(String message) {
        throw new UserException.MalformedVCF(message, this.lineNo);
    }

    protected static void generateException(String message, int lineNo) {
        throw new UserException.MalformedVCF(message, lineNo);
    }

    private VariantContext parseVCFLine(String[] parts) {
        VariantContextBuilder builder = new VariantContextBuilder();
        builder.source(this.getName());
        ++this.lineNo;
        String chr = this.getCachedString(parts[0]);
        builder.chr(chr);
        int pos = Integer.valueOf(parts[1]);
        builder.start(pos);
        if (parts[2].length() == 0) {
            this.generateException("The VCF specification requires a valid ID field");
        } else if (parts[2].equals(".")) {
            builder.noID();
        } else {
            builder.id(parts[2]);
        }
        String ref = this.getCachedString(parts[3].toUpperCase());
        String alts = this.getCachedString(parts[4].toUpperCase());
        builder.log10PError(AbstractVCFCodec.parseQual(parts[5]));
        builder.filters(this.parseFilters(this.getCachedString(parts[6])));
        builder.attributes(this.parseInfo(parts[7]));
        List<Allele> alleles = AbstractVCFCodec.parseAlleles(ref, alts, this.lineNo);
        int loc = pos;
        if (alleles.size() == 1) {
            loc = pos + alleles.get(0).length() - 1;
        } else if (!AbstractVCFCodec.isSingleNucleotideEvent(alleles)) {
            ArrayList<Allele> newAlleles = new ArrayList<Allele>();
            loc = AbstractVCFCodec.clipAlleles(pos, ref, alleles, newAlleles, this.lineNo);
            alleles = newAlleles;
        }
        builder.stop(loc);
        builder.alleles(alleles);
        if (parts.length > 8) {
            LazyVCFGenotypesParser lazyParser = new LazyVCFGenotypesParser(alleles, chr, pos);
            int nGenotypes = this.header.getGenotypeSamples().size();
            LazyGenotypesContext lazy = new LazyGenotypesContext(lazyParser, parts[8], nGenotypes);
            if (!this.header.samplesWereAlreadySorted()) {
                lazy.decode();
            }
            builder.genotypesNoValidation(lazy);
        }
        VariantContext vc = null;
        try {
            builder.referenceBaseForIndel(ref.getBytes()[0]);
            vc = builder.make();
        }
        catch (Exception e) {
            this.generateException(e.getMessage());
        }
        return vc;
    }

    public Class<VariantContext> getFeatureType() {
        return VariantContext.class;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    protected String getCachedString(String str) {
        String internedString = this.stringCache.get(str);
        if (internedString == null) {
            internedString = new String(str);
            this.stringCache.put(internedString, internedString);
        }
        return internedString;
    }

    private Map<String, Object> parseInfo(String infoField) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (infoField.length() == 0) {
            this.generateException("The VCF specification requires a valid info field");
        }
        if (!infoField.equals(".")) {
            if (infoField.indexOf("\t") != -1 || infoField.indexOf(" ") != -1) {
                this.generateException("The VCF specification does not allow for whitespace in the INFO field");
            }
            int infoFieldSplitSize = ParsingUtils.split(infoField, this.infoFieldArray, ';', false);
            for (int i = 0; i < infoFieldSplitSize; ++i) {
                ArrayList<String> value;
                String key;
                int eqI = this.infoFieldArray[i].indexOf("=");
                if (eqI != -1) {
                    key = this.infoFieldArray[i].substring(0, eqI);
                    String str = this.infoFieldArray[i].substring(eqI + 1);
                    int infoValueSplitSize = ParsingUtils.split(str, this.infoValueArray, ',', false);
                    if (infoValueSplitSize == 1) {
                        value = this.infoValueArray[0];
                    } else {
                        ArrayList<String> valueList = new ArrayList<String>(infoValueSplitSize);
                        for (int j = 0; j < infoValueSplitSize; ++j) {
                            valueList.add(this.infoValueArray[j]);
                        }
                        value = valueList;
                    }
                } else {
                    key = this.infoFieldArray[i];
                    value = true;
                }
                attributes.put(key, value);
            }
        }
        return attributes;
    }

    protected static Allele oneAllele(String index, List<Allele> alleles) {
        if (index.equals(".")) {
            return Allele.NO_CALL;
        }
        int i = Integer.valueOf(index);
        if (i >= alleles.size()) {
            throw new TribbleException.InternalCodecException("The allele with index " + index + " is not defined in the REF/ALT columns in the record");
        }
        return alleles.get(i);
    }

    protected static List<Allele> parseGenotypeAlleles(String GT, List<Allele> alleles, Map<String, List<Allele>> cache) {
        List<Allele> GTAlleles = cache.get(GT);
        if (GTAlleles == null) {
            StringTokenizer st = new StringTokenizer(GT, "/|\\");
            GTAlleles = new ArrayList<Allele>(st.countTokens());
            while (st.hasMoreTokens()) {
                String genotype = st.nextToken();
                GTAlleles.add(AbstractVCFCodec.oneAllele(genotype, alleles));
            }
            cache.put(GT, GTAlleles);
        }
        return GTAlleles;
    }

    protected static Double parseQual(String qualString) {
        if (qualString.equals(".")) {
            return 1.0;
        }
        Double val = Double.valueOf(qualString);
        if (val < 0.0 && Math.abs(val - VCFConstants.MISSING_QUALITY_v3_DOUBLE) < VCFConstants.VCF_ENCODING_EPSILON) {
            return 1.0;
        }
        return val / -10.0;
    }

    protected static List<Allele> parseAlleles(String ref, String alts, int lineNo) {
        ArrayList<Allele> alleles = new ArrayList<Allele>(2);
        AbstractVCFCodec.checkAllele(ref, true, lineNo);
        Allele refAllele = Allele.create(ref, true);
        alleles.add(refAllele);
        if (alts.indexOf(",") == -1) {
            AbstractVCFCodec.parseSingleAltAllele(alleles, alts, lineNo);
        } else {
            for (String alt : alts.split(",")) {
                AbstractVCFCodec.parseSingleAltAllele(alleles, alt, lineNo);
            }
        }
        return alleles;
    }

    private static void checkAllele(String allele, boolean isRef, int lineNo) {
        if (allele == null || allele.length() == 0) {
            AbstractVCFCodec.generateException("Empty alleles are not permitted in VCF records", lineNo);
        }
        if (AbstractVCFCodec.isSymbolicAllele(allele)) {
            if (isRef) {
                AbstractVCFCodec.generateException("Symbolic alleles not allowed as reference allele: " + allele, lineNo);
            }
        } else {
            if (allele.charAt(0) == 'D' || allele.charAt(0) == 'I') {
                AbstractVCFCodec.generateException("Insertions/Deletions are not supported when reading 3.x VCF's. Please convert your file to VCF4 using VCFTools, available at http://vcftools.sourceforge.net/index.html", lineNo);
            }
            if (!Allele.acceptableAlleleBases(allele)) {
                AbstractVCFCodec.generateException("Unparsable vcf record with allele " + allele, lineNo);
            }
            if (isRef && allele.equals(".")) {
                AbstractVCFCodec.generateException("The reference allele cannot be missing", lineNo);
            }
        }
    }

    private static boolean isSymbolicAllele(String allele) {
        return allele != null && allele.startsWith("<") && allele.endsWith(">") && allele.length() > 2;
    }

    private static void parseSingleAltAllele(List<Allele> alleles, String alt, int lineNo) {
        AbstractVCFCodec.checkAllele(alt, false, lineNo);
        Allele allele = Allele.create(alt, false);
        if (!allele.isNoCall()) {
            alleles.add(allele);
        }
    }

    protected static boolean isSingleNucleotideEvent(List<Allele> alleles) {
        for (Allele a : alleles) {
            if (a.length() == 1) continue;
            return false;
        }
        return true;
    }

    public static int computeForwardClipping(List<Allele> unclippedAlleles, String ref) {
        boolean clipping = true;
        for (Allele a : unclippedAlleles) {
            if (a.isSymbolic() || a.length() >= 1 && a.getBases()[0] == ref.getBytes()[0]) continue;
            clipping = false;
            break;
        }
        return clipping ? 1 : 0;
    }

    protected static int computeReverseClipping(List<Allele> unclippedAlleles, String ref, int forwardClipping, int lineNo) {
        int clipping = 0;
        boolean stillClipping = true;
        while (stillClipping) {
            for (Allele a : unclippedAlleles) {
                if (a.isSymbolic()) continue;
                if (a.length() - clipping == 0) {
                    return clipping - 1;
                }
                if (a.length() - clipping <= forwardClipping || a.length() - forwardClipping == 0) {
                    stillClipping = false;
                    continue;
                }
                if (ref.length() == clipping) {
                    AbstractVCFCodec.generateException("bad alleles encountered", lineNo);
                    continue;
                }
                if (a.getBases()[a.length() - clipping - 1] == ref.getBytes()[ref.length() - clipping - 1]) continue;
                stillClipping = false;
            }
            if (!stillClipping) continue;
            ++clipping;
        }
        return clipping;
    }

    protected static int clipAlleles(int position, String ref, List<Allele> unclippedAlleles, List<Allele> clippedAlleles, int lineNo) {
        int forwardClipping = AbstractVCFCodec.computeForwardClipping(unclippedAlleles, ref);
        int reverseClipping = AbstractVCFCodec.computeReverseClipping(unclippedAlleles, ref, forwardClipping, lineNo);
        if (clippedAlleles != null) {
            for (Allele a : unclippedAlleles) {
                if (a.isSymbolic()) {
                    clippedAlleles.add(a);
                    continue;
                }
                clippedAlleles.add(Allele.create(Arrays.copyOfRange(a.getBases(), forwardClipping, a.getBases().length - reverseClipping), a.isReference()));
            }
        }
        int refLength = ref.length() - reverseClipping;
        return position + Math.max(refLength - 1, 0);
    }

    public static final boolean canDecodeFile(String potentialInput, String MAGIC_HEADER_LINE) {
        try {
            return AbstractVCFCodec.isVCFStream(new FileInputStream(potentialInput), MAGIC_HEADER_LINE) || AbstractVCFCodec.isVCFStream(new GZIPInputStream(new FileInputStream(potentialInput)), MAGIC_HEADER_LINE) || AbstractVCFCodec.isVCFStream(new BlockCompressedInputStream(new FileInputStream(potentialInput)), MAGIC_HEADER_LINE);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean isVCFStream(InputStream stream, String MAGIC_HEADER_LINE) {
        try {
            boolean eq;
            byte[] buff = new byte[MAGIC_HEADER_LINE.length()];
            int nread = stream.read(buff, 0, MAGIC_HEADER_LINE.length());
            boolean bl = eq = Arrays.equals(buff, MAGIC_HEADER_LINE.getBytes());
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        catch (RuntimeException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }

    private static final class VCFLocFeature
    implements Feature {
        final String chr;
        final int start;
        final int stop;

        private VCFLocFeature(String chr, int start, int stop) {
            this.chr = chr;
            this.start = start;
            this.stop = stop;
        }

        @Override
        public String getChr() {
            return this.chr;
        }

        @Override
        public int getStart() {
            return this.start;
        }

        @Override
        public int getEnd() {
            return this.stop;
        }
    }

    class LazyVCFGenotypesParser
    implements LazyGenotypesContext.LazyParser {
        final List<Allele> alleles;
        final String contig;
        final int start;

        LazyVCFGenotypesParser(List<Allele> alleles, String contig, int start) {
            this.alleles = alleles;
            this.contig = contig;
            this.start = start;
        }

        @Override
        public LazyGenotypesContext.LazyData parse(Object data) {
            return AbstractVCFCodec.this.createGenotypeMap((String)data, this.alleles, this.contig, this.start);
        }
    }
}

