/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.fragments;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.utils.fragments.FragmentCollection;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class FragmentUtils {
    private static final ReadGetter<GATKSAMRecord> SamRecordGetter = new ReadGetter<GATKSAMRecord>(){

        @Override
        public GATKSAMRecord get(GATKSAMRecord object) {
            return object;
        }
    };
    private static final ReadGetter<PileupElement> PileupElementGetter = new ReadGetter<PileupElement>(){

        @Override
        public GATKSAMRecord get(PileupElement object) {
            return object.getRead();
        }
    };

    private FragmentUtils() {
    }

    private static final <T> FragmentCollection<T> create(Iterable<T> readContainingObjects, int nElements, ReadGetter<T> getter) {
        Collection singletons = null;
        ArrayList<List<Object>> overlapping = null;
        HashMap<String, T> nameMap = null;
        int lastStart = -1;
        for (T p : readContainingObjects) {
            Object pe1;
            GATKSAMRecord read = getter.get(p);
            if (read.getAlignmentStart() < lastStart) {
                throw new IllegalArgumentException(String.format("FragmentUtils.create assumes that the incoming objects are ordered by SAMRecord alignment start, but saw a read %s with alignment start %d before the previous start %d", read.getSAMString(), read.getAlignmentStart(), lastStart));
            }
            lastStart = read.getAlignmentStart();
            int mateStart = read.getMateAlignmentStart();
            if (mateStart == 0 || mateStart > read.getAlignmentEnd()) {
                if (singletons == null) {
                    singletons = new ArrayList(nElements);
                }
                singletons.add(p);
                continue;
            }
            String readName = ((SAMRecord)read).getReadName();
            Object v0 = pe1 = nameMap == null ? null : nameMap.get(readName);
            if (pe1 != null) {
                if (overlapping == null) {
                    overlapping = new ArrayList<List<Object>>();
                }
                overlapping.add(Arrays.asList(pe1, p));
                nameMap.remove(readName);
                continue;
            }
            if (nameMap == null) {
                nameMap = new HashMap<String, T>(nElements);
            }
            nameMap.put(readName, p);
        }
        if (nameMap != null && !nameMap.isEmpty()) {
            if (singletons == null) {
                singletons = nameMap.values();
            } else {
                singletons.addAll(nameMap.values());
            }
        }
        return new FragmentCollection(singletons, overlapping);
    }

    public static final FragmentCollection<PileupElement> create(ReadBackedPileup rbp) {
        return FragmentUtils.create(rbp, rbp.getNumberOfElements(), PileupElementGetter);
    }

    public static final FragmentCollection<GATKSAMRecord> create(List<GATKSAMRecord> reads) {
        return FragmentUtils.create(reads, reads.size(), SamRecordGetter);
    }

    public static interface ReadGetter<T> {
        public GATKSAMRecord get(T var1);
    }
}

