/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.activeregion;

import java.util.ArrayList;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.HasGenomeLocation;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class ActiveRegion
implements HasGenomeLocation {
    private final ArrayList<GATKSAMRecord> reads = new ArrayList();
    private final GenomeLoc activeRegionLoc;
    private final GenomeLoc extendedLoc;
    private final int extension;
    private GenomeLoc fullExtentReferenceLoc = null;
    private final GenomeLocParser genomeLocParser;
    public final boolean isActive;

    public ActiveRegion(GenomeLoc activeRegionLoc, boolean isActive, GenomeLocParser genomeLocParser, int extension) {
        this.activeRegionLoc = activeRegionLoc;
        this.isActive = isActive;
        this.genomeLocParser = genomeLocParser;
        this.extension = extension;
        this.fullExtentReferenceLoc = this.extendedLoc = genomeLocParser.createGenomeLoc(activeRegionLoc.getContig(), activeRegionLoc.getStart() - extension, activeRegionLoc.getStop() + extension);
    }

    public void add(GATKSAMRecord read) {
        this.fullExtentReferenceLoc = this.fullExtentReferenceLoc.union(this.genomeLocParser.createGenomeLoc(read));
        this.reads.add(read);
    }

    public ArrayList<GATKSAMRecord> getReads() {
        return this.reads;
    }

    public byte[] getReference(IndexedFastaSequenceFile referenceReader) {
        return this.getReference(referenceReader, 0);
    }

    public byte[] getReference(IndexedFastaSequenceFile referenceReader, int padding) {
        return referenceReader.getSubsequenceAt(this.fullExtentReferenceLoc.getContig(), Math.max(1, this.fullExtentReferenceLoc.getStart() - padding), Math.min(referenceReader.getSequenceDictionary().getSequence(this.fullExtentReferenceLoc.getContig()).getSequenceLength(), this.fullExtentReferenceLoc.getStop() + padding)).getBases();
    }

    @Override
    public GenomeLoc getLocation() {
        return this.activeRegionLoc;
    }

    public GenomeLoc getExtendedLoc() {
        return this.extendedLoc;
    }

    public GenomeLoc getReferenceLoc() {
        return this.fullExtentReferenceLoc;
    }

    public int getExtension() {
        return this.extension;
    }

    public int size() {
        return this.reads.size();
    }

    public void clearReads() {
        this.reads.clear();
    }

    public void remove(GATKSAMRecord read) {
        this.reads.remove(read);
    }

    public void removeAll(ArrayList<GATKSAMRecord> readsToRemove) {
        this.reads.removeAll(readsToRemove);
    }
}

