/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatibleWalker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.ExperimentalAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.GenotypeAnnotation;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFormatHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class AlleleBalanceBySample
extends GenotypeAnnotation
implements ExperimentalAnnotation {
    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatibleWalker walker, ReferenceContext ref, AlignmentContext stratifiedContext, VariantContext vc, Genotype g) {
        Double ratio = this.annotateSNP(stratifiedContext, vc, g);
        if (ratio == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getKeyNames().get(0), String.format("%.2f", (double)ratio));
        return map;
    }

    private Double annotateSNP(AlignmentContext stratifiedContext, VariantContext vc, Genotype g) {
        int altCount;
        double ratio = -1.0;
        if (!vc.isSNP()) {
            return null;
        }
        if (!vc.isBiallelic()) {
            return null;
        }
        if (g == null || !g.isCalled()) {
            return null;
        }
        if (!g.isHet()) {
            return null;
        }
        List<Allele> altAlleles = vc.getAlternateAlleles();
        if (altAlleles.size() == 0) {
            return null;
        }
        if (!stratifiedContext.hasBasePileup()) {
            return null;
        }
        String bases = new String(stratifiedContext.getBasePileup().getBases());
        if (bases.length() == 0) {
            return null;
        }
        char refChr = vc.getReference().toString().charAt(0);
        char altChr = vc.getAlternateAllele(0).toString().charAt(0);
        int refCount = MathUtils.countOccurrences(refChr, bases);
        if (refCount + (altCount = MathUtils.countOccurrences(altChr, bases)) == 0) {
            return null;
        }
        ratio = (double)refCount / (double)(refCount + altCount);
        return ratio;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("AB");
    }

    @Override
    public List<VCFFormatHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFFormatHeaderLine(this.getKeyNames().get(0), 1, VCFHeaderLineType.Float, "Allele balance for each het genotype"));
    }
}

