/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.arguments.DbsnpArgumentCollection;
import org.broadinstitute.sting.gatk.arguments.StandardVariantContextInputArgumentCollection;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.AlignmentContextUtils;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.Allows;
import org.broadinstitute.sting.gatk.walkers.By;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.Reference;
import org.broadinstitute.sting.gatk.walkers.Requires;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.Window;
import org.broadinstitute.sting.gatk.walkers.annotator.VariantAnnotatorEngine;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotationType;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatibleWalker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.GenotypeAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.StandardAnnotation;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.classloader.PluginManager;
import org.broadinstitute.sting.utils.codecs.vcf.VCFCompoundHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineCount;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

@Requires(value={})
@Allows(value={DataSource.READS, DataSource.REFERENCE})
@Reference(window=@Window(start=-50, stop=50))
@By(value=DataSource.REFERENCE)
public class VariantAnnotator
extends RodWalker<Integer, Integer>
implements AnnotatorCompatibleWalker {
    @ArgumentCollection
    protected StandardVariantContextInputArgumentCollection variantCollection = new StandardVariantContextInputArgumentCollection();
    @Input(fullName="snpEffFile", shortName="snpEffFile", doc="A SnpEff output file from which to add annotations", required=false)
    public RodBinding<VariantContext> snpEffFile;
    @ArgumentCollection
    protected DbsnpArgumentCollection dbsnp = new DbsnpArgumentCollection();
    @Input(fullName="comp", shortName="comp", doc="comparison VCF file", required=false)
    public List<RodBinding<VariantContext>> comps = Collections.emptyList();
    @Input(fullName="resource", shortName="resource", doc="external resource VCF file", required=false)
    public List<RodBinding<VariantContext>> resources = Collections.emptyList();
    @Output(doc="File to which variants should be written", required=true)
    protected VCFWriter vcfWriter = null;
    @Argument(fullName="annotation", shortName="A", doc="One or more specific annotations to apply to variant calls", required=false)
    protected List<String> annotationsToUse = new ArrayList<String>();
    @Argument(fullName="excludeAnnotation", shortName="XA", doc="One or more specific annotations to exclude", required=false)
    protected List<String> annotationsToExclude = new ArrayList<String>();
    @Argument(fullName="group", shortName="G", doc="One or more classes/groups of annotations to apply to variant calls", required=false)
    protected List<String> annotationGroupsToUse = new ArrayList<String>();
    @Argument(fullName="expression", shortName="E", doc="One or more specific expressions to apply to variant calls; see documentation for more details", required=false)
    protected List<String> expressionsToUse = new ArrayList<String>();
    @Argument(fullName="useAllAnnotations", shortName="all", doc="Use all possible annotations (not for the faint of heart)", required=false)
    protected Boolean USE_ALL_ANNOTATIONS = false;
    @Argument(fullName="list", shortName="ls", doc="List the available annotations and exit")
    protected Boolean LIST = false;
    @Argument(fullName="alwaysAppendDbsnpId", shortName="alwaysAppendDbsnpId", doc="In conjunction with the dbSNP binding, append the dbSNP ID even when the variant VCF already has the ID field populated")
    protected Boolean ALWAYS_APPEND_DBSNP_ID = false;
    @Hidden
    @Argument(fullName="vcfContainsOnlyIndels", shortName="dels", doc="Use if you are annotating an indel vcf, currently VERY experimental", required=false)
    protected boolean indelsOnly = false;
    @Argument(fullName="MendelViolationGenotypeQualityThreshold", shortName="mvq", required=false, doc="The genotype quality treshold in order to annotate mendelian violation ratio")
    public double minGenotypeQualityP = 0.0;
    @Argument(fullName="requireStrictAlleleMatch", shortName="strict", doc="If provided only comp tracks that exactly match both reference and alternate alleles will be counted as concordant", required=false)
    private boolean requireStrictAlleleMatch = false;
    private VariantAnnotatorEngine engine;
    private Collection<VariantContext> indelBufferContext;

    @Override
    public RodBinding<VariantContext> getSnpEffRodBinding() {
        return this.snpEffFile;
    }

    @Override
    public RodBinding<VariantContext> getDbsnpRodBinding() {
        return this.dbsnp.dbsnp;
    }

    @Override
    public List<RodBinding<VariantContext>> getCompRodBindings() {
        return this.comps;
    }

    @Override
    public List<RodBinding<VariantContext>> getResourceRodBindings() {
        return this.resources;
    }

    @Override
    public boolean alwaysAppendDbsnpId() {
        return this.ALWAYS_APPEND_DBSNP_ID;
    }

    private void listAnnotationsAndExit() {
        System.out.println("\nStandard annotations in the list below are marked with a '*'.");
        List<Class<InfoFieldAnnotation>> infoAnnotationClasses = new PluginManager<InfoFieldAnnotation>(InfoFieldAnnotation.class).getPlugins();
        System.out.println("\nAvailable annotations for the VCF INFO field:");
        for (int i = 0; i < infoAnnotationClasses.size(); ++i) {
            System.out.println("\t" + (StandardAnnotation.class.isAssignableFrom(infoAnnotationClasses.get(i)) ? "*" : "") + infoAnnotationClasses.get(i).getSimpleName());
        }
        System.out.println();
        List<Class<GenotypeAnnotation>> genotypeAnnotationClasses = new PluginManager<GenotypeAnnotation>(GenotypeAnnotation.class).getPlugins();
        System.out.println("\nAvailable annotations for the VCF FORMAT field:");
        for (int i = 0; i < genotypeAnnotationClasses.size(); ++i) {
            System.out.println("\t" + (StandardAnnotation.class.isAssignableFrom(genotypeAnnotationClasses.get(i)) ? "*" : "") + genotypeAnnotationClasses.get(i).getSimpleName());
        }
        System.out.println();
        System.out.println("\nAvailable classes/groups of annotations:");
        for (Class<AnnotationType> c : new PluginManager<AnnotationType>(AnnotationType.class).getInterfaces()) {
            System.out.println("\t" + c.getSimpleName());
        }
        System.out.println();
        System.exit(0);
    }

    @Override
    public void initialize() {
        if (this.LIST.booleanValue()) {
            this.listAnnotationsAndExit();
        }
        List<String> rodName = Arrays.asList(this.variantCollection.variants.getName());
        Set<String> samples = SampleUtils.getUniqueSamplesFromRods(this.getToolkit(), rodName);
        this.engine = this.USE_ALL_ANNOTATIONS != false ? new VariantAnnotatorEngine(this.annotationsToExclude, this, this.getToolkit()) : new VariantAnnotatorEngine(this.annotationGroupsToUse, this.annotationsToUse, this.annotationsToExclude, this, this.getToolkit());
        this.engine.initializeExpressions(this.expressionsToUse);
        this.engine.setRequireStrictAlleleMatch(this.requireStrictAlleleMatch);
        HashSet<VCFHeaderLine> hInfo = new HashSet<VCFHeaderLine>();
        hInfo.addAll(this.engine.getVCFAnnotationDescriptions());
        for (VCFHeaderLine line : VCFUtils.getHeaderFields(this.getToolkit(), Arrays.asList(this.variantCollection.variants.getName()))) {
            if (!VariantAnnotator.isUniqueHeaderLine(line, hInfo)) continue;
            hInfo.add(line);
        }
        for (VariantAnnotatorEngine.VAExpression expression : this.engine.getRequestedExpressions()) {
            if (expression.fieldName.equals("ID")) {
                hInfo.add(new VCFInfoHeaderLine(expression.fullName, 1, VCFHeaderLineType.String, "ID field transferred from external VCF resource"));
                continue;
            }
            VCFCompoundHeaderLine targetHeaderLine = null;
            for (VCFHeaderLine line : VCFUtils.getHeaderFields(this.getToolkit(), Arrays.asList(expression.binding.getName()))) {
                VCFInfoHeaderLine infoline;
                if (!(line instanceof VCFInfoHeaderLine) || !(infoline = (VCFInfoHeaderLine)line).getName().equals(expression.fieldName)) continue;
                targetHeaderLine = infoline;
                break;
            }
            if (targetHeaderLine != null) {
                if (targetHeaderLine.getCountType() == VCFHeaderLineCount.INTEGER) {
                    hInfo.add(new VCFInfoHeaderLine(expression.fullName, targetHeaderLine.getCount(), targetHeaderLine.getType(), targetHeaderLine.getDescription()));
                    continue;
                }
                hInfo.add(new VCFInfoHeaderLine(expression.fullName, targetHeaderLine.getCountType(), targetHeaderLine.getType(), targetHeaderLine.getDescription()));
                continue;
            }
            hInfo.add(new VCFInfoHeaderLine(expression.fullName, VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "Value transferred from another external VCF resource"));
        }
        this.engine.invokeAnnotationInitializationMethods(hInfo);
        VCFHeader vcfHeader = new VCFHeader(hInfo, samples);
        this.vcfWriter.writeHeader(vcfHeader);
        if (this.indelsOnly) {
            this.indelBufferContext = null;
        }
    }

    public static boolean isUniqueHeaderLine(VCFHeaderLine line, Set<VCFHeaderLine> currentSet) {
        if (!(line instanceof VCFCompoundHeaderLine)) {
            return true;
        }
        for (VCFHeaderLine hLine : currentSet) {
            if (!(hLine instanceof VCFCompoundHeaderLine) || !((VCFCompoundHeaderLine)line).sameLineTypeAndName((VCFCompoundHeaderLine)hLine)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public boolean includeReadsWithDeletionAtLoci() {
        return true;
    }

    @Override
    public boolean generateExtendedEvents() {
        return this.indelsOnly;
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        Map<String, AlignmentContext> stratifiedContexts;
        if (tracker == null) {
            return 0;
        }
        List<VariantContext> VCs = tracker.getValues(this.variantCollection.variants, context.getLocation());
        if (VCs.size() == 0) {
            return 0;
        }
        List<VariantContext> annotatedVCs = VCs;
        if (BaseUtils.simpleBaseToBaseIndex(ref.getBase()) != -1 && (stratifiedContexts = !context.hasExtendedEventPileup() ? AlignmentContextUtils.splitContextBySampleName(context.getBasePileup()) : AlignmentContextUtils.splitContextBySampleName(context.getExtendedEventPileup())) != null) {
            annotatedVCs = new ArrayList<VariantContext>(VCs.size());
            for (VariantContext vc : VCs) {
                annotatedVCs.add(this.engine.annotateContext(tracker, ref, stratifiedContexts, vc));
            }
        }
        if (!this.indelsOnly) {
            for (VariantContext annotatedVC : annotatedVCs) {
                this.vcfWriter.add(annotatedVC);
            }
        } else if (this.indelBufferContext != null && !VariantContextUtils.getLocation(this.getToolkit().getGenomeLocParser(), this.indelBufferContext.iterator().next()).equals(VariantContextUtils.getLocation(this.getToolkit().getGenomeLocParser(), (VariantContext)annotatedVCs.iterator().next()))) {
            for (VariantContext annotatedVC : this.indelBufferContext) {
                this.vcfWriter.add(annotatedVC);
            }
            this.indelBufferContext = annotatedVCs;
        } else {
            this.indelBufferContext = annotatedVCs;
        }
        return 1;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return sum + value;
    }

    @Override
    public void onTraversalDone(Integer result) {
        logger.info("Processed " + result + " loci.\n");
    }
}

