/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import org.broadinstitute.sting.gatk.walkers.genotyper.DiploidGenotype;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypePriors;
import org.broadinstitute.sting.gatk.walkers.indels.HaplotypeIndelErrorModel;
import org.broadinstitute.sting.utils.MathUtils;

public class DiploidIndelGenotypePriors
implements GenotypePriors {
    public static final double INDEL_HETEROZYGOSITY = 1.0E-4;
    private static final double[] flatPriors = new double[DiploidGenotype.values().length];
    private double[] priors = null;

    public DiploidIndelGenotypePriors() {
        this.priors = (double[])flatPriors.clone();
    }

    public DiploidIndelGenotypePriors(double indelHeterozygosity, int eventLength, int haplotypeSize) {
        double varPrior = this.getHaplotypePriors(indelHeterozygosity, eventLength, haplotypeSize);
        this.priors[2] = Math.log10(varPrior * varPrior);
        this.priors[1] = Math.log10(2.0 * varPrior * (1.0 - varPrior));
        this.priors[0] = Math.log10((1.0 - varPrior) * (1.0 - varPrior));
    }

    @Override
    public double[] getPriors() {
        return this.priors;
    }

    public double getPrior(DiploidGenotype g) {
        return this.getPriors()[g.ordinal()];
    }

    @Override
    public double getHeterozygosity() {
        return 1.0E-4;
    }

    @Override
    public boolean validate(boolean throwException) {
        try {
            for (DiploidGenotype g : DiploidGenotype.values()) {
                int i = g.ordinal();
                if (MathUtils.wellFormedDouble(this.priors[i]) && MathUtils.isNegativeOrZero(this.priors[i])) continue;
                String bad = String.format("Prior %f is badly formed %b", this.priors[i], MathUtils.isNegativeOrZero(this.priors[i]));
                throw new IllegalStateException(String.format("At %s: %s", g.toString(), bad));
            }
        }
        catch (IllegalStateException e) {
            if (throwException) {
                throw new RuntimeException(e);
            }
            return false;
        }
        return true;
    }

    public double getHaplotypePriors(double indelHeterozygosity, int eventLength, int haplotypeSize) {
        double lambda = (double)haplotypeSize * indelHeterozygosity;
        return HaplotypeIndelErrorModel.probToQual(lambda) - HaplotypeIndelErrorModel.probToQual(eventLength) * 1.89 + 0.15 * (double)eventLength + HaplotypeIndelErrorModel.probToQual(1.5716) + HaplotypeIndelErrorModel.probToQual(0.5);
    }

    static {
        for (DiploidGenotype g : DiploidGenotype.values()) {
            DiploidIndelGenotypePriors.flatPriors[g.ordinal()] = Math.log10(1.0 / (double)DiploidGenotype.values().length);
        }
    }
}

