/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import java.util.HashMap;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.TableType;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

class SampleStats
implements TableType {
    private final int nGenotypeTypes;
    public final HashMap<String, long[][]> concordanceStats = new HashMap();

    @Override
    public Object[] getRowKeys() {
        return this.concordanceStats.keySet().toArray(new String[this.concordanceStats.size()]);
    }

    public void incrValue(String sample, Genotype.Type truth, Genotype.Type called) {
        if (this.concordanceStats.containsKey(sample)) {
            long[] lArray = this.concordanceStats.get(sample)[truth.ordinal()];
            int n = called.ordinal();
            lArray[n] = lArray[n] + 1L;
        } else if (called != Genotype.Type.NO_CALL) {
            throw new UserException.CommandLineException("Sample " + sample + " has not been seen in a previous eval; this analysis module assumes that all samples are present in each variant context");
        }
    }

    @Override
    public Object[] getColumnKeys() {
        return new String[]{"total_true_ref", "pct_ref_vs_ref", "n_ref_vs_no_call", "n_ref_vs_ref", "n_ref_vs_het", "n_ref_vs_hom", "total_true_het", "pct_het_vs_het", "n_het_vs_no_call", "n_het_vs_ref", "n_het_vs_het", "n_het_vs_hom", "total_true_hom", "pct_hom_vs_hom", "n_hom_vs_no_call", "n_hom_vs_ref", "n_hom_vs_het", "n_hom_vs_hom"};
    }

    public SampleStats(VariantContext vc, int nGenotypeTypes) {
        this.nGenotypeTypes = nGenotypeTypes;
        for (Genotype g : vc.getGenotypes()) {
            this.concordanceStats.put(g.getSampleName(), new long[nGenotypeTypes][nGenotypeTypes]);
        }
    }

    public SampleStats(int genotypeTypes) {
        this.nGenotypeTypes = genotypeTypes;
    }

    @Override
    public Object getCell(int x, int y) {
        Genotype.Type type = Genotype.Type.values()[y / 6 + 1];
        long total = 0L;
        Object[] rowKeys = this.getRowKeys();
        for (int called = 0; called < this.nGenotypeTypes; ++called) {
            total += this.concordanceStats.get(rowKeys[x])[type.ordinal()][called];
        }
        switch (y % 6) {
            case 0: {
                return total;
            }
            case 1: {
                return total == 0L ? 0.0 : 100.0 * (double)this.concordanceStats.get(rowKeys[x])[type.ordinal()][type.ordinal()] / (double)total;
            }
        }
        return this.concordanceStats.get(rowKeys[x])[type.ordinal()][y % 6 - 2];
    }

    @Override
    public String getName() {
        return "Sample Statistics";
    }
}

